

drop table if exists customers cascade;
create table customers
(
	id serial primary key,
	first_name varchar(30),
	last_name varchar(30),
	email varchar(60),
	points integer,
	wallet numeric
);


drop table if exists admins cascade;
create table admins
(
	id serial primary key,
	wallet numeric
);


drop table if exists events cascade;
create table events
(
	id serial primary key,
	name varchar(60),
	type varchar(60),
	date date,
	time time
);


drop sequence if exists tar_id_seq cascade;
create sequence tar_id_seq start 100;
drop table if exists tariffs cascade;
create table tariffs
(
	id integer default nextval('tar_id_seq') primary key,
	category varchar(20),
	price numeric
);

drop table if exists sectors cascade;
create table sectors
(
	id serial primary key,
	name varchar(30),
	is_for_game boolean,
	is_for_event boolean
);


drop table if exists assigned cascade;
create table assigned
(
	id serial primary key,
	event_id integer references events,
	sector_id integer references sectors,
	tariff_id integer references tariffs
);



drop table if exists places cascade;
create table places
(
	id serial primary key,
	sector_id integer references sectors, --nove:
	--seats:
	row_number integer,
	seat_number integer,
	--lounges:
	lounge_name varchar(30)
);


drop table if exists tickets cascade;
create table tickets
(
	id serial primary key,
	is_free boolean,
	is_sold boolean,
	is_used boolean,
	category varchar(30),
	event_id integer references events,
	place_id integer references places
);


drop table if exists reservations cascade;
create table reservations
(
	id serial primary key,
	--valid_from date,
	--valid_till date,
	valid_from timestamp,
	valid_till timestamp,
	is_confirmed boolean,
	is_paid boolean,
	customer_id integer references customers,
	ticket_id integer references tickets
);


drop table if exists payments cascade;
create table payments
(
	id serial primary key,
	amount numeric,
	payment_date date,
	customer_id integer references customers,
	admin_id integer references admins,
	ticket_id integer references tickets
);