--vymazanie dat
truncate customers, admins, events, tariffs, sectors, assigned, places, tickets, reservations, payments restart identity cascade;

---- pomocne tabulky

--first_names
drop table if exists first_names cascade;
create table first_names
(
	first_name varchar
);

insert into first_names (first_name)
values ('Bonifac'), ('Miroslav'), ('Bystrik'), ('Ctibor'),
('David'), ('Peter'), ('Jaro'), ('Jozef'), ('Matej'),
('Ondrej'), ('Samuel'), ('Patrik'), ('Dario'), ('Michal');
		
--last_names
drop table if exists last_names cascade;
create table last_names
(
	last_name varchar
);

insert into last_names (last_name)
values ('Vlk'), ('Medvedov'), ('Sova'), ('Kocur'),
('Rys'), ('Kamzik'), ('Vydra'), ('Lasica'),
('Kohut'), ('Beloritka'), ('Daniel'), ('Jelen');

--new_events

drop table if exists new_events cascade;
create table new_events
(
	event_name varchar
);
insert into new_events(event_name)
values ('Koncert Mira Zbirku'), ('Labuti balet'), ('Slovensko hlada SuperStart'),
('International Chess tournament'), ('Vystava aut znacky Lada');

--new_games
drop table if exists new_games cascade;
create table new_games
(
	game_name varchar
);
insert into new_games(game_name)
values ('HZ Slovan:Trencin'), ('HZ Horna Boca:Dolna Boca'), ('HZ Trnava:Nove Mesto nad Vahom'),
('HZ Trencin:Nitra'), ('HZ Nitra:Slovan'), ('HZ Horna Boca:Trencin'), ('HZ Trnava:Slovan');

drop table if exists game_types cascade;
create table game_types
(
	name varchar
);
insert into game_types
values ('play-off'), ('zakladna cast');

drop table if exists categories cascade;
create table categories
(
	cat_name varchar
);
insert into categories(cat_name)
values ('child'), ('student'), ('senior'), ('adult');


------ Hlavne tabulky

----Customers

create or replace function random_first_name() returns varchar language sql as 
$$
select first_name from first_names tablesample system_rows(10) order by random() limit 1
$$;

create or replace function random_last_name() returns varchar language sql as 
$$
select last_name from last_names tablesample system_rows(10) order by random() limit 1
$$;

--meno, priezv., body, peniaze
insert into customers (first_name, last_name, points, wallet)
select random_first_name(),
		random_last_name(),
		floor(random() * 30) as points,
		floor(random() * 200) as wallet  --nejde round :(
from generate_series(1, 100000) as seq(i);  --povodne 400, teraz podme vyssie
--ich mail
update customers SET
	email = concat( lower( substring(first_name, 1, 1) ), '@', lower( last_name), '.sk' );


----Events

create or replace function random_new_event() returns varchar language sql as
$$
select event_name from new_events tablesample system_rows(10) order by random() limit 1
$$;

create or replace function random_new_game() returns varchar language sql as
$$
select game_name from new_games tablesample system_rows(10) order by random() limit 1
$$;

create or replace function random_game_type() returns varchar language sql as
$$
select name from game_types tablesample system_rows(2) order by random() limit 1
$$;

create or replace function random_time() returns time language sql as
$$
select concat( floor(random() * 2)::varchar, floor(random() * 10)::varchar, ':',floor(random()*6)::varchar, '0:00')::time
$$;

create or replace function random_date() returns date language sql as
$$
select date '2020-05-01' + floor(random() * 100)::integer --nahodny datum
$$;

--podujatia: meno, false, datum
insert into events (name, type, date, time)
select random_new_event(),
		'podujatie',
		random_date(),
		random_time()
from generate_series(1, 100) as seq(i); --ZMENIT PRE NAROCNOST

--hry: meno, true, datum
insert into events(name, type, date, time)
select random_new_game(),
		random_game_type(),
		random_date(),
		random_time()
from generate_series(1, 100) as seq(i); --ZMENIT PRE NAROCNOST


----Sectors
create or replace function write_letter(i in integer) returns varchar language sql as
$$
select chr(cast(65 + i as integer)); 
$$;

create or replace function random_boolean() returns boolean language sql as
$$
select cast( round(random())::integer as boolean )
$$;

--name, is_for_game, is_for_event - seats
insert into sectors(name, is_for_game, is_for_event)
select write_letter(i),
		random_boolean(),
		random_boolean()
from generate_series(0, floor(random() * 10 + 10)::integer) as seq(i); --ZMENIT PRE NAROCNOST

--name, is_for_game, is_for_event - vip
insert into sectors(name, is_for_game, is_for_event)
select CONCAT('VIP', (i+1)),
		random_boolean(),
		random_boolean()
from generate_series(0, floor(random() * 10)::integer) as seq(i); --ZMENIT PRE NAROCNOST


----Places
create or replace function row_length(x in integer) returns table(seat_number integer) language sql as
$$
select * from generate_series(1, x)
$$;
create or replace function row_amount(x in integer) returns table (row_number integer) language sql as
$$
select * from generate_series(1, x)
$$;
create or replace function lounge_amount(x in integer) returns table(lounge_name varchar) language sql as
$$
select concat('L', i) from generate_series(1, x) as seq(i)
$$;

--sector_id, row_number, seat_number
insert into places(sector_id, row_number, seat_number)
select id, row_number, seat_number
from sectors
cross join row_amount(floor(random()* 10 + 20)::integer) --ZMENIT PRE OBTIAZNOST
cross join row_length(floor(random() * 10 + 30)::integer) --ZMENIT PRE OBTIAZNOST
where name NOT LIKE '%VIP%';

--sector_id, lounge
insert into places(sector_id, lounge_name)
select id, lounge_name
from sectors
cross join lounge_amount(5) --ZMENIT PRE NAROCNOST
where name LIKE '%VIP%';


----Tickets
--TABLESAMPLE???
create or replace function random_place_game() returns integer language sql as
$$
select p.id from places p 
inner join sectors s tablesample system_rows(10)  on (p.sector_id = s.id)
where s.is_for_game = true 
order by random() limit 1
$$;


drop table if exists help_game_place cascade;
create table help_game_place (id integer);
insert into help_game_place(id) values(random_place_game());

--ostatne
create or replace function random_cat() returns varchar language sql as
$$
select cat_name from categories tablesample system_rows(4) order by random() limit 1
$$;
--is_free, is_sold, is_used, event_id, place_id
insert into tickets(is_free, is_sold, is_used, event_id, place_id)
select random_boolean(), false, false, e.id, p.id
from places p
inner join sectors s on s.id = p.sector_id
cross join events e
where (e.type = 'podujatie' and s.is_for_event = true) or (e.type != 'podujatie' and s.is_for_game = true);

--is_sold update
update tickets SET
	is_sold = random_boolean() where is_free = false;
--is_used, category  update
update tickets SET
	is_used = is_sold AND random_boolean(), category = random_cat() where is_free = false and category is null;

--permanentka
update tickets SET
	(is_free, is_sold, is_used, category) = 
	(false, true, random_boolean(), 'permanent') 
	where event_id in (select id from events where type = 'zakladna cast') and place_id = (select id from help_game_place);
	
----Reservations

create or replace function random_customer_id() returns integer language sql as
$$
select id from customers tablesample system_rows(5) order by random() limit 1
$$;

--nahodny listok, ktory nie je permanentka
create or replace function random_sold_ticket_id() returns integer language sql as
$$
select t.id from tickets t
left join reservations r tablesample system_rows(10)
on t.id = r.ticket_id
where r.ticket_id is null and t.is_sold = true and t.category != 'permanent'
order by random() limit 1
$$;

create or replace function random_timestamp() returns timestamp language sql as
$$
select date_trunc('minute', 
		timestamp '2020-05-01 20:00:00' +
       random() * (timestamp '2025-12-31 20:00:00' - timestamp '2020-05-01 20:00:00')
				   )
$$;

create or replace function after_3_days(tstamp in timestamp) returns timestamp language sql as
$$
select cast(tstamp + interval '+3 days' as timestamp)
$$;

--najde jednu vygenerovanu permanentku
create or replace function find_permanent_id() returns integer language sql as
$$
select t.id from tickets t where t.category = 'permanent' limit 1
$$;

--tie listky, co nie su volne ale ani kupene - mozu byt len rezervovane, ale nie permanentky
insert into reservations(valid_from, is_confirmed, is_paid, customer_id, ticket_id) 
select 	random_timestamp(),
		random_boolean(),
		false,
		random_customer_id(),
		t.id
from tickets t where is_free = false and is_sold = false and category != 'permanent';

--permanentka

insert into reservations(valid_from, is_confirmed, is_paid, customer_id, ticket_id)
values (random_timestamp(), true, true, random_customer_id(), find_permanent_id());

--ostatne nahodne
insert into reservations(valid_from, is_confirmed, customer_id, ticket_id) 
select 	random_timestamp(),
		random_boolean(),
		random_customer_id(),
		random_sold_ticket_id()
from generate_series(1, 500);
--valid_till
update reservations set
	valid_till = (select * from after_3_days(valid_from));
--is_paid
update reservations set
	is_paid = random_boolean() where is_paid is null;
update reservations set
	is_paid = false where  is_confirmed = false;
	
	
----Tariffs

---category, price, event_id

--podujatia maju kazde zvlast nahdne hodnoty
insert into tariffs(category, price)
select cat_name, 1 + floor(random() * 10)::integer
from events e
cross join categories c
where e.type = 'podujatie';

--zakladna cast - spolocne hodnoty -> spolocne id
insert into tariffs(id, category, price)
values (10, 'child', 5), (11, 'adult', 10), (12, 'senior', 6), (13, 'student', 8), (14, 'permanent', 30);
--play-off - spolocne hodnoty
insert into tariffs(id, category, price)
values (20, 'child', 9), (21, 'adult', 18), (22, 'senior', 10), (23, 'student', 15), (24, 'permanent', 54);


----assigned

--event_id, sector_id, tariff_id
create or replace function rand_event_child_tar_id() returns integer language sql as
$$
select id from tariffs tablesample system_rows(5) where id > 99 and category = 'child' order by random() limit 1
$$;

create or replace function rand_event_adult_tar_id() returns integer language sql as
$$
select id from tariffs tablesample system_rows(5) where id > 99 and category = 'adult' order by random() limit 1
$$;

create or replace function rand_event_senior_tar_id() returns integer language sql as
$$
select id from tariffs tablesample system_rows(5) where id > 99 and category = 'senior' order by random() limit 1
$$;

create or replace function rand_event_student_tar_id() returns integer language sql as
$$
select id from tariffs tablesample system_rows(5) where id > 99 and category = 'student' order by random() limit 1
$$;

drop table if exists tariff_help cascade;
create table tariff_help(
	id integer
);
insert into tariff_help(id)
values (rand_event_child_tar_id()), (rand_event_adult_tar_id()), (rand_event_senior_tar_id()), (rand_event_student_tar_id());

--podujatia
insert into assigned(event_id, sector_id, tariff_id)
select e.id, s.id, t.id
from events e
cross join tariff_help t
cross join sectors s
where e.type = 'podujatie' and s.is_for_event = true;

--zakladna cast
insert into assigned(event_id, sector_id, tariff_id)
select e.id, s.id, t.id
from events e
cross join tariffs t
cross join sectors s
where e.type = 'zakladna cast' and s.is_for_game = true and t.id between 10 and 19;

--play-off
insert into assigned(event_id, sector_id, tariff_id)
select e.id, s.id, t.id
from events e
cross join tariffs t
cross join sectors s
where e.type = 'play-off' and s.is_for_game = true and t.id between 20 and 29;



----Admins
insert into admins(wallet)
select 0 from generate_series(1, 3) as seq(i);

----Payments

--amount, payment_date, customer_id, admin_id, ticket_id

--online
insert into payments(amount, payment_date, customer_id, admin_id, ticket_id)
select distinct ta.price, r.valid_from, r.customer_id, 1, r.ticket_id
from reservations r
inner join tickets ti on r.ticket_id = ti.id
inner join assigned a using (event_id)
inner join tariffs ta on ta.id = a.tariff_id
where ti.category = ta.category and r.is_paid = true;

--pladby v pokladni
insert into payments(amount, payment_date,  admin_id, ticket_id)
select distinct ta.price, e.date, 2, ti.id
from tickets ti
left join reservations r on (r.ticket_id = ti.id)
inner join events e on (ti.event_id = e.id)
inner join assigned a on (a.event_id = e.id)
inner join tariffs ta on (ta.id = a.tariff_id)
where r.ticket_id is null
and ti.is_sold = true
and ti.category = ta.category;


drop function random_first_name();
drop function random_last_name();
drop function random_new_event();
drop function random_new_game();
drop function random_game_type();
drop function random_time();
drop function random_date();
drop function write_letter(i in integer);
drop function random_boolean();
drop function row_length(x in integer);
drop function row_amount(x in integer);
drop function lounge_amount(x in integer);
drop function random_place_game();
drop function random_cat();
drop function random_customer_id();
drop function random_sold_ticket_id();
drop function random_timestamp();
drop function after_3_days(tstamp in timestamp);
drop function find_permanent_id();
drop function rand_event_adult_tar_id();
drop function rand_event_child_tar_id();
drop function rand_event_senior_tar_id();
drop function rand_event_student_tar_id();

drop table first_names, last_names, new_events, new_games, game_types, categories, tariff_help, help_game_place cascade;




