package rdg;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.SQLException;

import Exceptions.IdNotFoundException;
import main.DBContext;

public class Admin {
	private Integer id;
	private BigDecimal wallet;
	
	public Integer getId() {
		return id;
	}
	public void setId(Integer id) {
		this.id = id;
	}
	
	public BigDecimal getWallet() {
		return wallet;
	}
	public void setWallet(BigDecimal wallet) {
		this.wallet = wallet;
	}
	/**
	 * Updates database with current values.
	 * 
	 * @throws IdNotFoundException if id is null
	 * @throws SQLException when sql query throws its exception
	 */
	public void update() throws IdNotFoundException, SQLException {
		if(id == null) throw new IdNotFoundException("Admin with this id not found");
		String sql = "UPDATE admins SET wallet = ? WHERE id = ?";
		try(PreparedStatement ps = DBContext.getConnection().prepareStatement(sql)) {
			ps.setBigDecimal(1, wallet);
			ps.setInt(2, id);
			
			ps.executeUpdate();
		}
	}
}
