package rdg;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import main.DBContext;

public class AdminFinder {
	
	private static final AdminFinder INSTANCE = new AdminFinder();
	
	/**
	 * Returns instance of AdminFinder
	 * @return INSTANCE of AdminFinder class
	 */
	public static AdminFinder getInstance() {
		return INSTANCE;
	}
	
	private AdminFinder() {}
	
	/**
	 * Returns Admin from database
	 * @param id specifies wanted admin
	 * @return admin from database with the specified id
	 * @throws SQLException when sql query throws its exception
	 */
	public Admin findById(int id) throws SQLException {
		String sql = "SELECT * FROM admins WHERE id = ?";
		try(PreparedStatement ps = DBContext.getConnection().prepareStatement(sql)){
			ps.setInt(1, id);
			
			try(ResultSet rs = ps.executeQuery()){
				if(rs.next()) {
					Admin admin = new Admin();
					admin.setId(id);
					admin.setWallet(rs.getBigDecimal(2));
					
					if(rs.next()) System.out.println("More rows returned");
					
					return admin;
				}
				else return null;
			}
			
		}
	}
}
