package rdg;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import main.DBContext;

public class Assigned {
	private int id;
	private int eventId;
	private int sectorId;
	private int TariffId;
	
	public int getId() {
		return id;
	}
	public void setId(int id) {
		this.id = id;
	}
	
	public int getEventId() {
		return eventId;
	}
	public void setEventId(int eventId) {
		this.eventId = eventId;
	}
	
	public int getSectorId() {
		return sectorId;
	}
	public void setSectorId(int sectorId) {
		this.sectorId = sectorId;
	}
	
	public int getTariffId() {
		return TariffId;
	}
	public void setTariffId(int tariffId) {
		TariffId = tariffId;
	}
	/**
	 * Inserts new Assigned into database with current values
	 * @throws SQLException when sql query throws its exception
	 */
	public void insert() throws SQLException {
		String sql = "INSERT INTO assigned (event_id, sector_id, tariff_id) VALUES (?,?,?)";
		try(PreparedStatement ps = DBContext.getConnection().prepareStatement(sql, Statement.RETURN_GENERATED_KEYS)){
			ps.setInt(1, eventId);
			ps.setInt(2, sectorId);
			ps.setInt(3, TariffId);
			
			ps.executeUpdate();
			
			try (ResultSet rs = ps.getGeneratedKeys()){
				rs.next();
				id = rs.getInt(1);
			}
		}
	}
}
