package rdg;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import main.DBContext;

public class AssignedFinder {
	
	private static final AssignedFinder INSTANCE = new AssignedFinder();
	
	/**
	 * Returns instance of AssignedFinder
	 * @return INSTANCE of AssignedFinder class
	 */
	public static AssignedFinder getInstance() {
		return INSTANCE;
	}
	
	private AssignedFinder() {}
	
	/**
	 * Returns Assigned from database
	 * @param id specifies wanted assigned
	 * @return Assigned from database with specified id
	 * @throws SQLException when sql query throw its exception
	 */
	public Assigned findById(int id) throws SQLException {
		String sql = "SELECT * FROM assigned WHERE id = ?";
		try(PreparedStatement ps = DBContext.getConnection().prepareStatement(sql)){
			ps.setInt(1, id);
			
			try(ResultSet rs = ps.executeQuery()){
				if(rs.next()) {
					Assigned assigned = new Assigned();
					assigned.setId(rs.getInt(1));
					assigned.setEventId(rs.getInt(2));
					assigned.setSectorId(rs.getInt(3));
					assigned.setTariffId(rs.getInt(4));
					
					if(rs.next()) System.out.println("More rows returned");
					
					return assigned;
				}
				else return null;
			}
			
		}
	}
}
