package rdg;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import Exceptions.IdNotFoundException;
import main.DBContext;

public class Customer {
	private Integer id;
	private String firstName;
	private String lastName;
	private String email;
	private Integer points;
	private BigDecimal wallet;
	
	public void setId(Integer id) {
		this.id = id;
	}
	public Integer getId() {
		return id;
	}
	
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}
	public String getFirstName() {
		return firstName;
	}
	
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}
	public String getLastName() {
		return lastName;
	}
	
	public void setEmail(String email) {
		this.email = email;
	}
	public String getEmail() {
		return email;
	}
	
	public void setPoints(Integer points) {
		this.points = points;
	}
	public Integer getPoints() {
		return points;
	}
	
	public void setWallet(BigDecimal wallet) {
		this.wallet = wallet;
	}
	public BigDecimal getWallet() {
		return wallet;
	}
	
	public void print() {
		System.out.println(id + " " + firstName + " " + lastName + " " + email); 
	}
	
	public void printFull() {
		System.out.println(id + " " + firstName + " " + lastName + " " + email + " " + points + " " + wallet);
	}
	
	/**
	 * Inserts new customer into database with current values
	 * @throws SQLException when sql update throws its exception
	 */
	public void insert() throws SQLException {
		String sql = "INSERT INTO customers (first_name, last_name, email, points, wallet) VALUES (?,?,?,?,?)";
		try(PreparedStatement ps = DBContext.getConnection().prepareStatement(sql, Statement.RETURN_GENERATED_KEYS)){
			ps.setString(1, firstName);
			ps.setString(2, lastName);
			ps.setString(3, email);
			ps.setInt(4,  points);
			ps.setBigDecimal(5, wallet);
			
			ps.executeUpdate();
			
			try (ResultSet rs = ps.getGeneratedKeys()){
				rs.next();
				id = rs.getInt(1);
			}
		}
	}
	/**
	 * Updates current values of a customer in database
	 * @throws SQLException when sql update throws its exception
	 * @throws IdNotFoundException when id is null
	 */
	public void update() throws SQLException, IdNotFoundException {
		if(id == null) throw new IdNotFoundException("Customer id not found");
		
		String sql = "UPDATE customers SET first_name = ?, last_name = ?, email = ?, points = ?, wallet = ? WHERE id = ?";
		try (PreparedStatement ps = DBContext.getConnection().prepareStatement(sql)){
			ps.setString(1,  firstName);
			ps.setString(2, lastName);
			ps.setString(3, email);
			ps.setInt(4, points);
			ps.setBigDecimal(5, wallet);
			ps.setInt(6,  id);
			
			ps.executeUpdate();
		}
	}
}
