package rdg;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import Exceptions.MoreRowsReturnedException;
import main.DBContext;
 // prevzate zo vzoroveho projektu
public class CustomerFinder {
	
	private static final CustomerFinder INSTANCE = new CustomerFinder();
	
	/**
	 * Returns instance of CustomerFinder
	 * @return INSTANCE of CustomerFinder class
	 */
	public static CustomerFinder getInstance() {
		return INSTANCE;
	}
	
	private CustomerFinder() {}
	
	/**
	 * Returns Customer from database specified by id
	 * @param id of wanted Customer
	 * @return Customer with specified id
	 * @throws SQLException when sql query throws its exception
	 * @throws MoreRowsReturnedException when more Customer than one are returned
	 */
	public Customer findById(int id) throws SQLException {
		String sql = "SELECT * FROM customers WHERE id = ?";
		try(PreparedStatement ps = DBContext.getConnection().prepareStatement(sql)){
			ps.setInt(1, id);
			
			try(ResultSet rs = ps.executeQuery()){
				if(rs.next()) {
					Customer customer = new Customer();
					customer.setId(rs.getInt(1));
					customer.setFirstName(rs.getString(2));
					customer.setLastName(rs.getString(3));
					customer.setEmail(rs.getString(4));
					customer.setPoints(rs.getInt(5));
					customer.setWallet(rs.getBigDecimal(6));
					
					if(rs.next()) System.out.println("More rows returned");
					
					return customer;
				}
				else return null;
			}
			
		}
	}
	
}
