package rdg;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import Exceptions.MoreRowsReturnedException;
import main.DBContext;

public class EventFinder {

		private static final EventFinder INSTANCE = new EventFinder();
		
		/**
		 * Returns instance of EventFinder
		 * @return INSTANCE of EventFinder class
		 */
		public static EventFinder getInstance() {
			 return INSTANCE;
		}
		
		private EventFinder() {}
		
		/**
		 * Returns event from database with specified id
		 * @param id specifies wanted event
		 * @return event from database with specified id
		 * @throws SQLException when sql query throws its exception
		 * @throws MoreRowsReturnedException when more events than one are returned
		 */
		public Event findById(int id) throws SQLException, MoreRowsReturnedException {
			String sql = "SELECT * FROM events WHERE id = ?";
			try(PreparedStatement ps = DBContext.getConnection().prepareStatement(sql)){
				ps.setInt(1,  id);
				
				try(ResultSet rs = ps.executeQuery()){
					if(rs.next()) {
						Event event = new Event();
						event.setId(rs.getInt(1));
						event.setName(rs.getString(2));
						event.setType(rs.getString(3));
						event.setDate(rs.getDate(4));
						event.setTime(rs.getTime(5));
						
						if(rs.next()) throw new MoreRowsReturnedException("More events returned");
						
						return event;
					}
					else return null;
				}
			}
		}
}
