package rdg;

import java.math.BigDecimal;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Date;

import main.DBContext;

public class Payment {

	private Integer id;
	private BigDecimal amount;
	private Date paymentDate;
	private Integer customerId;
	private Integer adminId;
	private Integer ticketId;
	
	public Integer getId() {
		return id;
	}
	public void setId(Integer id) {
		this.id = id;
	}
	
	public BigDecimal getAmount() {
		return amount;
	}
	public void setAmount(BigDecimal amount) {
		this.amount = amount;
	}
	
	public Date getPaymentDate() {
		return paymentDate;
	}
	public void setPaymentDate(Date paymentDate) {
		this.paymentDate = paymentDate;
	}
	
	public Integer getCustomerId() {
		return customerId;
	}
	public void setCustomerId(Integer customerId) {
		this.customerId = customerId;
	}
	
	public Integer getAdminId() {
		return adminId;
	}
	public void setAdminId(Integer adminId) {
		this.adminId = adminId;
	}
	
	public Integer getTicketId() {
		return ticketId;
	}
	public void setTicketId(Integer ticketId) {
		this.ticketId = ticketId;
	}
	
	/**
	 * Insert new payment into database with current values
	 * @throws SQLException when sql update throws its exception
	 */
	public void insert() throws SQLException {
		String sql = "INSERT INTO payments(amount, payment_date, customer_id, admin_id, ticket_id) "
				+ "VALUES (?,?,?,?,?)";
		try(PreparedStatement ps = DBContext.getConnection().prepareStatement(sql, Statement.RETURN_GENERATED_KEYS)) {
			ps.setBigDecimal(1, amount);
			ps.setDate(2, paymentDate);
			if(customerId == null) {
				ps.setNull(3, java.sql.Types.INTEGER);
			} else {
				ps.setInt(3, customerId);
			}
			ps.setInt(4, adminId);
			ps.setInt(5, ticketId);
			
			ps.executeUpdate();
			
			try(ResultSet rs = ps.getGeneratedKeys()) {
				rs.next();
				id = rs.getInt(1);
			}
		}
	}
}
