package rdg;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import Exceptions.MoreRowsReturnedException;
import main.DBContext;

public class PaymentFinder {
	
	public static final PaymentFinder INSTANCE = new PaymentFinder();
	
	/**
	 * Returns instance of PaymentFinder
	 * @return INSTANCE of PaymentFinder class
	 */
	public static PaymentFinder getInstance() {
		return INSTANCE;
	}
	
	private PaymentFinder() {}
	
	/**
	 * Returns Payment from database specified by id
	 * @param id of wanted payment
	 * @return Payment with specified id
	 * @throws SQLException when sql query throws its exception
	 * @throws MoreRowsReturnedException when more payments than one are returned
	 */
	public Payment findById(int id) throws SQLException, MoreRowsReturnedException {
		String sql = "SELECT * FROM payments WHERE id = ?";
		try(PreparedStatement ps = DBContext.getConnection().prepareStatement(sql)) {
			ps.setInt(1, id);
			try(ResultSet rs = ps.executeQuery()) {
				if(rs.next()) {
					Payment payment = new Payment();
					payment.setId(rs.getInt(1));
					payment.setAmount(rs.getBigDecimal(2));
					payment.setPaymentDate(rs.getDate(3));
					payment.setCustomerId(rs.getInt(4));
					payment.setAdminId(rs.getInt(5));
					payment.setTicketId(rs.getInt(6));
					
					if(rs.next()) throw new MoreRowsReturnedException("More rows returned");
					
					return payment;
				}
				else return null;
			}
		}
	}

}
