package rdg;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import Exceptions.MoreRowsReturnedException;
import main.DBContext;

public class PlaceFinder {
	
	public static final PlaceFinder INSTANCE = new PlaceFinder();
	
	private PlaceFinder() {}
	
	/**
	 * Returns instance of PlaceFinder
	 * @return INSTANCE of PlaceFiner class
	 */
	public static PlaceFinder getInstance() {
		return INSTANCE;
	}
	 /**
	  * Returns Place from database specified by id
	  * @param id of wanted Place
	  * @return Place with specified id
	  * @throws SQLException when sql throws its exception
	 * @throws MoreRowsReturnedException when more places than one are returned
	  */
	public Place findById(int id) throws SQLException, MoreRowsReturnedException {
		String sql = "SELECT * FROM places WHERE id = ?";
		try(PreparedStatement ps = DBContext.getConnection().prepareStatement(sql)) {
			ps.setInt(1, id);
			try(ResultSet rs = ps.executeQuery()){
				if(rs.next()) {
					Place place = new Place();
					place.setId(id);
					place.setSectorId(rs.getInt(2));
					place.setRowNumber(rs.getInt(3));
					place.setSeatNumber(rs.getInt(4));
					place.setLoungeName(rs.getString(5));
					
					if(rs.next()) throw new MoreRowsReturnedException("More places returned");
					
					return place;
				}
				
			}
		}
		return null;
	}

}
