package rdg;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import Exceptions.MoreRowsReturnedException;
import main.DBContext;

public class ReservationFinder {
	
	public static final ReservationFinder INSTANCE = new ReservationFinder();
	
	public ReservationFinder() {}
	
	/**
	 * Returns instance of ReservationFinder
	 * @return INSTANCE of ReservationFinder class
	 */
	public static ReservationFinder getInstance() {
		return INSTANCE;
	}
	
	/**
	 * Returns Reservation from database specified by id
	 * @param id of wanted Reservation
	 * @return Reservation with specified id
	 * @throws SQLException when sql query throws its exception
	 * @throws MoreRowsReturnedException when more Reservation than one are returned
	 */
	public static Reservation findByID(int id) throws SQLException, MoreRowsReturnedException {
		String sql = "SELECT * FROM reservations WHERE id = ?";
		try(PreparedStatement ps = DBContext.getConnection().prepareStatement(sql)) {
			ps.setInt(1, id);
			try(ResultSet rs = ps.executeQuery()) {
				if(rs.next()) {
					Reservation reservation = new Reservation();
					reservation.setId(rs.getInt(1));
					reservation.setValidFrom(rs.getTimestamp(2).toLocalDateTime());
					reservation.setValidTill(rs.getTimestamp(3).toLocalDateTime());
					reservation.setConfirmed(rs.getBoolean(4));
					reservation.setPaid(rs.getBoolean(5));
					reservation.setCustomerId(rs.getInt(6));
					reservation.setTicketId(rs.getInt(7));
					
					if(rs.next()) throw new MoreRowsReturnedException("More rows returned");
					
					return reservation;
				} 
				else return null;
			}
		}
		
	}

}
