package rdg;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import Exceptions.MoreRowsReturnedException;
import main.DBContext;

public class SectorFinder {
	
	private static final SectorFinder INSTANCE = new SectorFinder();
	
	/**
	 * Returns instance of SectorFinder
	 * @return INSTANCE of SectorFinder class
	 */
	public static SectorFinder getInstance() {
		return INSTANCE;
	}
	
	private SectorFinder() {}
	
	/**
	 * Returns Sector from database specified by id
	 * @param id of wanted Sector
	 * @return Sector with specified id
	 * @throws SQLException when sql query throws its exception
	 * @throws MoreRowsReturnedException when more Sector than one are returned
	 */
	public Sector findById(int id) throws SQLException, MoreRowsReturnedException {
		String sql = "SELECT * FROM sectors WHERE id = ?";
		try(PreparedStatement ps = DBContext.getConnection().prepareStatement(sql)) {
			ps.setInt(1, id);
			
			try(ResultSet rs = ps.executeQuery()){
				if(rs.next()) {
					Sector sector = new Sector();
					sector.setId(rs.getInt(1));
					sector.setName(rs.getString(2));
					sector.setForGame(rs.getBoolean(3));
					sector.setForEvent(rs.getBoolean(4));
					
					if(rs.next()) throw new MoreRowsReturnedException("More sectors returned");
					
					return sector;
				}
				else return null;
			}
		}
	}

}
