package rdg;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

import main.DBContext;

public class Tariff {
	private int id;
	private String category;
	private double price;
	
	public static final int[] zakladnaCast = new int[] {10, 11, 12, 13, 14};
	public static final int[] playOff = new int[] {20, 21, 22, 23, 24};

	
	public int getId() {
		return id;
	}
	public void setId(int id) {
		this.id = id;
	}
	
	public String getCategory() {
		return category;
	}
	public void setCategory(String category) {
		this.category = category;
	}
	
	public double getPrice() {
		return price;
	}
	public void setPrice(double price) {
		this.price = price;
	}
	
	/**
	 * Inserts new Tariff into database with current values
	 * @throws SQLException when sql update throws its exception
	 */
	public int insert() throws SQLException {
		String sql = "INSERT INTO tariffs (category, price) VALUES (?,?)";
		try(PreparedStatement ps = DBContext.getConnection().prepareStatement(sql, Statement.RETURN_GENERATED_KEYS)){
			ps.setString(1, category);
			ps.setDouble(2, price);
			
			ps.executeUpdate();
			
			try (ResultSet rs = ps.getGeneratedKeys()){
				rs.next();
				id = rs.getInt(1);
			}
		}
		return id;
	}
	
	
}
