package rdg;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import Exceptions.MoreRowsReturnedException;
import main.DBContext;

public class TariffFinder {
	private static final TariffFinder INSTANCE = new TariffFinder();
	
	/**
	 * Returns instance of TariffFinder
	 * @return INSTANCE of TariffFinder class
	 */
	public static TariffFinder getInstance() {
		return INSTANCE;
	}
	
	private TariffFinder() {}
	
	/**
	 * Returns Tariff from database specified by id
	 * @param id of wanted Tariff
	 * @return Tariff with specified id
	 * @throws SQLException when sql query throws its exception
	 * @throws MoreRowsReturnedException when more Tariff than one are returned
	 */
	public Tariff findById(int id) throws SQLException, MoreRowsReturnedException {
		String sql = "SELECT * FROM tariffs WHERE id = ?";
		try(PreparedStatement ps = DBContext.getConnection().prepareStatement(sql)){
			ps.setInt(1, id);
			
			try(ResultSet rs = ps.executeQuery()){
				if(rs.next()) {
					Tariff tariff = new Tariff();
					tariff.setId(id);
					tariff.setCategory(rs.getString(2));
					tariff.setPrice(rs.getDouble(3));
					
					if(rs.next()) throw new MoreRowsReturnedException("More rows returned");
					
					return tariff;
				}
				else return null;
			}
			
		}
	}
}
