package rdg;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import Exceptions.MoreRowsReturnedException;
import main.DBContext;

public class TicketFinder {
	
	private static final TicketFinder INSTANCE = new TicketFinder();
	
	/**
	 * Returns instance of TicketFinder
	 * @return INSTANCE of TicketFinder class
	 */
	public static TicketFinder getInstance() {
		return INSTANCE;
	}
	
	private TicketFinder() {}
	
	/**
	 * Returns Ticket from database specified by id
	 * @param id of wanted Ticket
	 * @return Ticket with specified id
	 * @throws SQLException when sql query throws its exception
	 * @throws MoreRowsReturnedException when more Ticket than one are returned
	 */
	public Ticket findById(int id) throws SQLException, MoreRowsReturnedException {
		String sql = "SELECT * FROM tickets WHERE id = ?";
		try(PreparedStatement ps = DBContext.getConnection().prepareStatement(sql)){
			ps.setInt(1, id);
			
			try(ResultSet rs = ps.executeQuery()){
				if(rs.next()) {
					Ticket ticket = new Ticket();
					ticket.setId(rs.getInt(1));
					ticket.setFree(rs.getBoolean(2));
					ticket.setSold(rs.getBoolean(3));
					ticket.setUsed(rs.getBoolean(4));
					ticket.setCategory(rs.getString(5));
					ticket.setEventID(rs.getInt(6));
					ticket.setPlaceID(rs.getInt(7));
					
					if(rs.next()) throw new MoreRowsReturnedException("More tickets returned");
					
					return ticket;
				}
				else return null;
			}
		}
	}
	
	public Ticket findByEventPlace(int eventId, int placeId) throws SQLException {
		String sql = "SELECT * FROM tickets WHERE event_id = ? AND place_id = ?";
		try(PreparedStatement ps = DBContext.getConnection().prepareStatement(sql)) {
			ps.setInt(1, eventId);
			ps.setInt(2, placeId);
			try(ResultSet rs = ps.executeQuery()) {
				if(rs.next()) {
					Ticket ticket = new Ticket();
					ticket.setId(rs.getInt(1));
					ticket.setFree(rs.getBoolean(2));
					ticket.setSold(rs.getBoolean(3));
					ticket.setUsed(rs.getBoolean(4));
					ticket.setCategory(rs.getString(5));
					ticket.setEventID(rs.getInt(6));
					ticket.setPlaceID(rs.getInt(7));
					
					if(rs.next()) System.out.println("More rows returned");
					
					return ticket;
				}
				else return null;
			}
		}
	}
	
	

}
