package ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.sql.SQLException;

import Exceptions.IdNotFoundException;
import rdg.Customer;
import rdg.CustomerFinder;

public class CustomerMenu extends Menu{
	@Override
	public void print() {
		System.out.println("*************************");
		System.out.println("0. back to main menu");
		System.out.println("1. add new customer");
		System.out.println("2. change existing customer");
		System.out.println("3. add funds by id");
		System.out.println("4. show points by id");
		System.out.println("5. print full info by id");
		System.out.println("*************************");
	}
	
	@Override
	public void handle(String option) throws NumberFormatException {
		try {
			switch(option) {
			default: System.out.println("Unknown command");break;
			case "0": mainMenu();break;
			case "1": addCustomer();break;
			case "2": changeCustomer();break;
			case "3": addFunds();break;
			case "4": showPoints();break;
			case "5": printFull();break;
			}
		}catch(SQLException | IOException | IdNotFoundException e) {
			e.printStackTrace();
		}
		
	}
	//0. back to main menu
	public void mainMenu() throws IOException {
		exit();
		MainMenu mMenu = new MainMenu();
		mMenu.run();
	}
	
	//1. create customer
	public void addCustomer() throws IOException, SQLException {
		BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
		Customer customer = new Customer();

		System.out.println("***New Customer:***");
		System.out.println("First name:");
		customer.setFirstName(br.readLine());
		System.out.println("Last name:");
		customer.setLastName(br.readLine());
		System.out.println("Customer's email:");
		customer.setEmail(br.readLine());
		
		customer.setPoints(0);
		customer.setWallet(BigDecimal.valueOf(0));
		/*
		System.out.println("Customer's points:");
		customer.setPoints(Integer.valueOf(br.readLine()));
		System.out.println("Customer's fortune:");
		customer.setWallet(new BigDecimal(br.readLine()));*/
		
		customer.insert();
		System.out.println("Customer has been added under id " + customer.getId());
	}
	//2. change customer
	public void changeCustomer() throws NumberFormatException, IOException, SQLException, IdNotFoundException {
		BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
		
		System.out.println("***Enter id:***");
		int id = Integer.valueOf(br.readLine());
		
		Customer customer = CustomerFinder.getInstance().findById(id);
		
		if(customer == null) {
			throw new IdNotFoundException("Can't find customer with this id");
		}
		else {
			System.out.println("Customer found:");
			customer.print();
			
			System.out.println("new first name:");
			customer.setFirstName(br.readLine());
			System.out.println("new last name:");
			customer.setLastName(br.readLine());
			System.out.println("new email:");
			customer.setEmail(br.readLine());
			/*
			System.out.println("new points:");
			customer.setPoints(Integer.valueOf(br.readLine()));
			System.out.println("new wallet:");
			customer.setWallet(new BigDecimal(br.readLine()));*/
			
			customer.update();
			System.out.println("Successfully updated!");
		}
	}
	
	//3. add funds by id
	public void addFunds() throws NumberFormatException, IOException, SQLException, IdNotFoundException {
		BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
		
		System.out.println("Enter customer id:");
		int id = Integer.valueOf(br.readLine());
		Customer customer = CustomerFinder.getInstance().findById(id);
		if(customer == null) {
			throw new IdNotFoundException("Can't find customer with this id");
		}
		else {
			System.out.println("Enter amount:");
			customer.setWallet(customer.getWallet().add(new BigDecimal(br.readLine())));
			customer.update();
			System.out.println("Successfully added!");
		}
	}
	
	//4. show points by id
	public void showPoints() throws NumberFormatException, IOException, SQLException, IdNotFoundException {
		BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
		
		System.out.println("Enter customer id:");
		int id = Integer.valueOf(br.readLine());
		Customer customer = CustomerFinder.getInstance().findById(id);
		if(customer == null) {
			throw new IdNotFoundException("Can't find customer with this id");
		}
		else {
			System.out.println("Customer " + customer.getFirstName() + " " 
											+ customer.getLastName() + " has " 
											+ customer.getPoints() + " points.");
		}
	}
	
	//5. print full info by id
	public void printFull() throws NumberFormatException, IOException, SQLException, IdNotFoundException {
		BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
		
		System.out.println("Enter customer id:");
		int id = Integer.valueOf(br.readLine());
		Customer customer = CustomerFinder.getInstance().findById(id);
		if(customer == null) {
			throw new IdNotFoundException("Can't find customer with this id");
		}
		else {
			System.out.println("Customer:");
			customer.printFull();
		}
	}

}
