package ui;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import Exceptions.EmptyResultException;
import Exceptions.EmptyResultListException;
import Exceptions.IdNotFoundException;
import Exceptions.MoreRowsReturnedException;
import Exceptions.ProcessCancelledException;
import Exceptions.WrongInputException;
import Transactions.EventManager;
import Transactions.SectorManager;
import Transactions.TicketManager;
import rdg.Event;
import rdg.EventFinder;
import rdg.Sector;
import rdg.Tariff;


public class EventMenu extends Menu{
	
	@Override
	public void print() {
		System.out.println("*****************************");
		System.out.println("0. back to main menu");
		System.out.println("1. find event by id");
		System.out.println("2. add game");
		System.out.println("3. add event");
		System.out.println("4. delete event");
		System.out.println("5. update event");
		System.out.println("6. event sales");
		System.out.println("7. show number of occupied places");
		System.out.println("8. monthly visits to games");
		System.out.println("9. midnight check");
		System.out.println("*****************************");
		
	}
	
	@Override
	public void handle(String option) {
		try {
			switch(option) {
			default: System.out.println("Unknown command");break;
			case "0": mainMenu();break;
			case "1": findEvent();break;
			case "2": addGame();break;
			case "3": addEvent();break;
			case "4": deleteEvent();break;
			case "5": updateEvent();break;
			case "6": eventSales();break;
			case "7": showOccupied();break;
			case "8": monthlyVisits();break;
			case "9": midnightCheck();break;
			}
		}catch( SQLException | IOException | NumberFormatException | IdNotFoundException | EmptyResultException | EmptyResultListException | WrongInputException | ProcessCancelledException | MoreRowsReturnedException e) {
			e.printStackTrace();
		}
		
	}
	
	//0. back to main menu
	public void mainMenu() throws IOException {
		exit();
		MainMenu mMenu = new MainMenu();
		mMenu.run();
	}
	//1. find event by id
	public void findEvent() throws IOException, SQLException, IdNotFoundException, WrongInputException, MoreRowsReturnedException {
		BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
		int id;
		try {
			System.out.println("***Enter id***");
			id = Integer.valueOf(br.readLine());
		} catch(NumberFormatException e){
			throw new WrongInputException("Wrong input type");
		}
		
		
		Event event = EventFinder.getInstance().findById(id);
		if(event == null) {
			throw new IdNotFoundException("Can't find event with this id");
		}
		System.out.println("***Event:");
		event.print();
	}

	
	//2. add game
	public void addGame() throws SQLException, EmptyResultListException, IOException, EmptyResultException, MoreRowsReturnedException {
		BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
		Event event = new Event();
		
		//name
		System.out.println("***New Game***");
		System.out.println("Name:");
		String inputName = br.readLine();
		if(inputName.equals("")) inputName = "TestGame"; //len enter
		event.setName(inputName);
		
		//type
		System.out.println("Type:");
		System.out.println("0: Zkladn as   -   1: Play-Off");
		String inputType = br.readLine();
		if(inputType.equals("")) inputType = "0"; //len enter
		int type = Integer.valueOf(inputType);
		if(type == 0) event.setType("zakladna cast");
		else if(type == 1) event.setType("play-off");
		else {
			System.out.println("Nepoznam moznost");
			return;
		}
		
		//date
		System.out.println("Date: YYYY-MM-DD");
		String inputDate = br.readLine();
		if(inputDate.equals("")) inputDate = "1998-07-02"; //len enter
		String[] arr = inputDate.split("-", 3);
		LocalDate localDate = LocalDate.of(Integer.valueOf(arr[0]), Integer.valueOf(arr[1]), Integer.valueOf(arr[2]));
		Date newDate = Date.valueOf(localDate);
		event.setDate(newDate);
		
		//time
		System.out.println("Time: HH:MM:SS");
		String inputTime = br.readLine();
		if(inputTime.equals("")) inputTime = "15:00:00"; //len enter
		LocalTime localTime = LocalTime.parse(inputTime);
		Time newTime = Time.valueOf(localTime);
		event.setTime(newTime);
		
		//choose sectors
		//zmenene na: vzdy zober vsetky sektory,
		//aby sa nestalo, ze niekto kupi permanentku na miesto,
		//ktoreho sektor sa neotvori
		List<Sector> sectors = SectorManager.getForGame();
		System.out.println("All sectors awailable for games are chosen:");
		String sectString = SectorManager.listString(sectors);
		System.out.println(sectString);
		
		int newId = EventManager.addGame(event, sectors);
		
		event.setId(newId);
		Event newEvent = EventFinder.getInstance().findById(event.getId());
		
		if(newEvent == null) {
			System.out.println("Unsuccessfull!");
		} else {
			System.out.println("Successfully added under ID " + newId);
		}
		
	}
	
	//3. add event
	public void addEvent() throws IOException, SQLException, EmptyResultListException {
		BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
		Event event = new Event();
		
		//name
		System.out.println("***New Event***");
		System.out.println("Name:");
		String inputName = br.readLine();
		if(inputName.equals("")) inputName = "TestEvent"; //len enter
		event.setName(inputName);
		
		//type
		event.setType("podujatie");
		
		//date
		System.out.println("Date: YYYY-MM-DD");
		String inputDate = br.readLine();
		if(inputDate.equals("")) inputDate = "1998-07-02"; //len enter
		String[] arr = inputDate.split("-", 3);
		LocalDate localDate = LocalDate.of(Integer.valueOf(arr[0]), Integer.valueOf(arr[1]), Integer.valueOf(arr[2]));
		Date newDate = Date.valueOf(localDate);
		event.setDate(newDate);
				
		//time
		System.out.println("Time: HH:MM:SS");
		String inputTime = br.readLine();
		if(inputTime.equals("")) inputTime = "15:00:00"; //len enter
		LocalTime localTime = LocalTime.parse(inputTime);
		Time newTime = Time.valueOf(localTime);
		event.setTime(newTime);
		
		//choose sectors
		List<Sector> chosenSectors;
		List<Sector> eventSectors = SectorManager.getForEvent();
		System.out.println("Choose sectors:                              napr:'A,B,C,D' pre sect. A,B,C,D    len enter pre vsetky");
		System.out.println(SectorManager.listString(eventSectors));
		String inputSec = br.readLine();
		if(inputSec.equals("")) chosenSectors = eventSectors;  //len enter
		else chosenSectors = SectorManager.getChosenSectors(eventSectors, Arrays.asList(inputSec.split(",")));
		
		////tariffy pre vybrane sektory
		Map<Sector, List<Tariff>> sectTarMap = new HashMap<Sector, List<Tariff>>();
		for(Sector s : chosenSectors) {
			System.out.println("Tariff for sector " + s.getName() + "       napr. 'adult-15,senior-30'    len enter pre adult-15,senior-9,child-3");
			String inputTar = br.readLine();
			if(inputTar.equals("")) inputTar = "adult-15,senior-9,child-3"; //len enter
			if(inputTar.equals("break")) throw new EmptyResultListException("skoncene, asi to chce vlastny exception");
			String[] tarStrs = inputTar.split(",");
			List<Tariff> tariffs = new ArrayList<Tariff>();
			for(String strT : tarStrs) {
				Tariff tariff = new Tariff();
				String[] parts = strT.split("-");
				tariff.setCategory(parts[0]);
				tariff.setPrice(Double.valueOf(parts[1]));
				tariffs.add(tariff);
			}
			sectTarMap.put(s, tariffs);
		}
		
		int id = EventManager.addEvent(event, sectTarMap);
		System.out.println("Event added under id " + id);
		
		
	}
	
	//7. show number of occupied places
	public void showOccupied() throws NumberFormatException, IOException, SQLException, IdNotFoundException, MoreRowsReturnedException {
		BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
		
		System.out.println("***Enter event ID***");
		int id = Integer.valueOf(br.readLine());
		
		Event event = EventFinder.getInstance().findById(id);
		
		if(event == null) {
			throw new IdNotFoundException("Can't find event with this id");
		}
		
		int all = event.getAllTicketCount();
		int reserved = event.getReservedTicketCount();
		int bought = event.getBoughtTicketCount();
		if(all < 0 && reserved < 0 && bought < 0) {
			System.out.println("Error");
			return;
		}
		System.out.println("From all seats: " + all);
		System.out.print((reserved + bought) + " are occupied -> ");
		System.out.print(reserved + " are reserved");
		System.out.print(" and " + bought + " have been bought.\n");
		System.out.println((all - bought - reserved) + " tickets are unoccupied.");
	}
	//4. delete event
	public void deleteEvent() throws NumberFormatException, IOException, SQLException, IdNotFoundException, MoreRowsReturnedException {
		BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
		
		System.out.println("***Enter event ID***");
		int id = Integer.valueOf(br.readLine());
		Event event = EventFinder.getInstance().findById(id);
		if(event == null) {
			System.out.println("Event not found");
			return;
		}
		event.delete();
		System.out.println("Successfully deleted!");
	}
	
	
	//5. update
	public void updateEvent() throws NumberFormatException, IOException, SQLException, IdNotFoundException, MoreRowsReturnedException {
		BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
		
		System.out.println("***Enter event ID***");
		int id = Integer.valueOf(br.readLine());
		Event event = EventFinder.getInstance().findById(id);
		if(event == null) {
			System.out.println("Event not found");
			return;
		}
		System.out.println("Event: ");
		event.print();
		
		//name
		System.out.println("New Name:");
		event.setName(br.readLine());
		
		//date
		System.out.println("New Date: YYYY-MM-DD");
		String[] arr = br.readLine().split("-", 3);
		LocalDate localDate = LocalDate.of(Integer.valueOf(arr[0]), Integer.valueOf(arr[1]), Integer.valueOf(arr[2]));
		Date newDate = Date.valueOf(localDate);
		event.setDate(newDate);
		
		//time
		System.out.println("New Time: HH:MM:SS");
		LocalTime localTime = LocalTime.parse(br.readLine());
		Time newTime = Time.valueOf(localTime);
		event.setTime(newTime);
		
		event.update();
		System.out.println("Successfully updated! New values:");
		event.print();
	}
	//6. event sales
	public void eventSales() throws NumberFormatException, IOException, SQLException, IdNotFoundException, EmptyResultException, MoreRowsReturnedException {
		BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
		
		System.out.println("***Enter event ID***");
		int id = Integer.valueOf(br.readLine());
		
		Double sales = EventManager.getSalesByID(id);
		if(sales == null) {
			throw new EmptyResultException("No sales returned");
		}
		System.out.println("Sales: " + sales);
		
	}
	
	//8. monthly visits
	public void monthlyVisits() throws SQLException, NumberFormatException, IOException, WrongInputException, EmptyResultException {
		BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
		
		System.out.println("Enter year:");
		int year = Integer.valueOf(br.readLine());
		EventManager.getAvgVisitsTransaction(year);
	}
	
	//9. midnight check
	public void midnightCheck() throws IOException, SQLException, ProcessCancelledException, EmptyResultException {
		BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
		
		System.out.println("Perform midnight check?       enter for yes    write something (+enter) for no");
		String answer = br.readLine();
		if(answer.equals("")) {
			int affected = TicketManager.midnightCheckTransaction();
			System.out.println("Successfull update! " + affected + " tickets affected!");
		} else throw new ProcessCancelledException("Check cancelled by user");
		
	}
}
