package ui;

import java.io.File;

import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.LocalDateTime;
import java.util.Scanner;

import main.DBContext;

public class MainMenu extends Menu{
	
	@Override
	public void print() {
		System.out.println("*****************************");
		System.out.println("0. exit");
		System.out.println("1. create script");
		System.out.println("2. generate script");
		System.out.println("3. customer menu");
		System.out.println("4. events menu");
		System.out.println("5. tickets menu");
		System.out.println("*****************************");
	}
	
	@Override
	public void handle(String option) {		
		try {
			switch(option) {
			default: System.out.println("Unknown command");break;
			case "0": exit();break;
			case "1": createScript();break;
			case "2": generateScript();break;
			case "3": customerMenu();break;
			case "4": eventMenu();break;
			case "5": ticketsMenu();break;
			}
		}catch(IOException e) {
			System.out.println("Error");
		}
	}
	
	//1. create script
	public void createScript() {
		try {
			File createScript = new File("C:\\Users\\Jozef\\eclipse-workspace\\DB2Project\\src\\sql\\create_script.sql");
			Scanner scan = new Scanner(createScript);
			String data = "";
			while(scan.hasNextLine()) {
				data += scan.nextLine() + "\n";
			}
			scan.close();
			
			//System.out.println("data:" + data);
			Connection c = DBContext.getConnection();
			try (Statement s = c.createStatement()) {
				s.executeUpdate(data);
			}
			catch (SQLException se) {
				se.printStackTrace();
			}
			
		}
		catch(Exception e) {
			System.out.println("Error");
		}
	}
	//2. generate script
	public void generateScript() {
		System.out.println("Zaciatok:" + LocalDateTime.now());
		try {
			File file = new File ("C:\\Users\\Jozef\\eclipse-workspace\\DB2Project\\src\\sql\\generate_script.sql");
			Scanner scan = new Scanner(file);
			String data = "";
			while(scan.hasNextLine()) {
				data += scan.nextLine() + "\n";
			}
			scan.close();
			//System.out.println(data);
			
			Connection c = DBContext.getConnection();
			try(Statement s = c.createStatement()){
				s.executeUpdate(data);
			}
			catch (SQLException se) {
				se.printStackTrace();
			}
		}catch (Exception e) {
			System.out.println("Nejaky error");
		}
		System.out.println("Koniec:" + LocalDateTime.now());
	}
	
	
	//3. customer menu
	public void customerMenu() throws IOException {
		exit();
		CustomerMenu cMenu = new CustomerMenu();
		cMenu.run();
	}
	
	//4. events menu
	public void eventMenu() throws IOException {
		exit();
		EventMenu eMenu = new EventMenu();
		eMenu.run();
	}
	
	//5. tickets menu
	public void ticketsMenu() throws IOException {
		exit();
		TicketsMenu tMenu = new TicketsMenu();
		tMenu.run();
	}
	
	
}
