import tkinter
from tkinter import *
import time

class Othello:

    class Player:

        def __init__(self, znak):
            self.znak = znak

    class Stvorec:

        def __init__(self, x, y, r, canvas, next=None):
            self.x, self.y, self.r, self.next = x, y, r, next
            self.farba = 'green'
            self.objekt = canvas.create_rectangle(x, y, x+r, y+r, width=2, fill=self.farba, outline='darkgrey')

    class Button:

        def __init__(self, meno, y, r, farba, canvas):
            self.meno, self.y, self.r, self.farba = meno, y, r, farba
            self.x = 400
            self.objekt = canvas.create_rectangle(self.x, self.y, self.x * 2, self.y + self.r, fill=farba)
            self.text = canvas.create_text(self.x * 1.5, self.y + (self.r / 2), text=self.meno, font='arial 40 bold')
            self.zaciatok_x, self.koniec_x = 400, 800
            self.zaciatok_y, self.koniec_y = self.y, self.y + self.r

    class Button_Exit:

        def __init__(self, canvas):
            canvas.create_rectangle(950, 20, 1150, 120, fill='yellow2')
            canvas.create_text(1050, 70, text="  Návrat \ndo menu", fill='red', font='arial 30 bold')

            self.zaciatok_x, self.koniec_x = 950, 1150
            self.zaciatok_y, self.koniec_y = 20, 120

    def __init__(self):

        self.potvrd = False
        
        self.plocha = [['-' for i in range(8)] for j in range(8)]
        self.clovek = self.Player('C')
        self.pocitac = self.Player('B')
        self.plocha[3][3], self.plocha[4][4] = self.pocitac.znak, self.pocitac.znak
        self.plocha[3][4], self.plocha[4][3] = self.clovek.znak, self.clovek.znak

        #-----Canvas
        self.sirka, self.vyska = 1200, 900
        self.root = tkinter.Tk()
        self.root.title("Othello")
        self.canvas = tkinter.Canvas(self.root, width=self.sirka, height=self.vyska, bg='khaki1')
        self.canvas.bind('<Button-1>', self.klik)

        #-----Volania
        #self.v_hre()
        #self.update()
        self.v_menu()

        

        self.canvas.pack()
        self.canvas.mainloop()

    #-----Hra

    def koniec(self, plocha):
        zoz = []
        for i in range(8):
            for j in range(8):
                zoz.append(plocha[i][j])
        if 'C' not in zoz:
            return True
        zoz = []
        for i in range(8):
            for j in range(8):
                zoz.append(plocha[i][j])
        if 'B' not in zoz:
            return True
        
        for i in range(8):
            for j in range(8):
                if plocha[i][j] == '-':
                    return False

        return True

    def skore(self, plocha):
        skore_pocitac, skore_clovek = 0, 0
        for i in range(8):
            for j in range(8):
                if plocha[i][j] == self.pocitac.znak:
                    skore_pocitac += 1
                if plocha[i][j] == self.clovek.znak:
                    skore_clovek += 1
        return {'clovek':skore_clovek, 'pocitac':skore_pocitac}

    def kopia_plochy(self, plocha):
        vysl = [['-' for i in range(8)] for j in range(8)]
        for i in range(8):
            for j in range(8):
                vysl[i][j] = plocha[i][j]
        return vysl
                
    def susedne(self, x, y):

        if y == 0:
            if x == 0:
                return (x + 1, y), (x, y + 1), (x + 1, y + 1)
            elif x == 7:
                return (x - 1, y), (x, y + 1), (x - 1, y - 1)
            elif 0 < x < 7:
                return (x - 1, y), (x, y + 1), (x + 1, y), (x + 1, y + 1), (x - 1, y + 1)

        elif y == 7:
            if x == 0:
                return (x + 1, y), (x, y - 1), (x + 1, y - 1)
            elif x == 7:
                return (x - 1, y), (x, y - 1), (x - 1, y - 1)
            elif 0 < x < 7:
                return (x - 1, y), (x, y - 1), (x + 1, y), (x - 1, y - 1), (x + 1, y - 1)

        elif 0 < y < 7:
            if x == 0:
                return (x, y - 1), (x + 1, y), (x, y + 1), (x + 1, y - 1), (x + 1, y + 1)
            elif x == 7:
                return (x, y - 1), (x - 1, y), (x, y + 1), (x - 1, y - 1), (x - 1, y+ 1)
            elif 0 < x < 7:
                return (x - 1, y), (x, y - 1), (x + 1, y), (x, y + 1), (x - 1, y - 1), (x - 1, y + 1), (x + 1, y - 1), (x + 1, y + 1)

    def moznosti(self, hrac, plocha):
        if hrac is self.clovek:
            protihrac = self.pocitac
        else:
            protihrac = self.clovek

        zaciatky = []
        for i in range(8):
             for j in range(8):
                 if plocha[i][j] == hrac.znak:
                     zaciatky.append([i, j])
        #print(zaciatky)
        nasiel = []
        for zaciatok in zaciatky:
            for sused in self.susedne(zaciatok[0], zaciatok[1]):
                if plocha[sused[0]][sused[1]] == protihrac.znak:
                    a, b = sused[0], sused[1]
                    smer_x, smer_y = zaciatok[0] - sused[0], zaciatok[1] - sused[1]
                    #print('zaciatok:', zaciatok, 'sused:', sused[0], sused[1], 'smery:', smer_x, smer_y)

                    while 0 <= a <= 7 and 0 <= b <= 7 and plocha[a][b] != hrac.znak and plocha[a][b] != '-':
                        a -= smer_x
                        b -= smer_y
                        #print('cyklus:', a, b)

                    if 0 <= a <= 7 and 0 <= b <= 7 and plocha[a][b] == '-' and [a, b] not in nasiel:
                        #print('nasiel som', a, b)
                        nasiel.append([a, b])
        #print('nasiel:', nasiel)
        return nasiel

    def sprav_tah(self, hrac, plocha, x, y):
        
        if [x, y] not in self.moznosti(hrac, plocha):
            #print('sprav_tah je False', [x, y])
            return False

        if plocha is self.plocha:
            self.oznac(x, y)

            
        zaciatky = []
        for i in range(8):
            for j in range(8):
                if plocha[i][j] == hrac.znak:
                    zaciatky.append([i, j])

        #print('zaciatky', zaciatky)
        #print(self.smer(x, y))
        dobre_zaciatky = []

##        for zaciatok in zaciatky:
##            if zaciatok in self.smer(x, y):
##                dobre_zaciatky.append(zaciatok)
        
        for zaciatok in zaciatky:
            if zaciatok in self.smer(x, y):
                if x - zaciatok[0] > 0:
                    smer_x = 1
                elif x - zaciatok[0] < 0:
                    smer_x = -1
                elif x == zaciatok[0]:
                    smer_x = 0
                if y - zaciatok[1] > 0:
                    smer_y = 1
                elif y - zaciatok[1] < 0:
                    smer_y = -1
                elif y == zaciatok[1]:
                    smer_y = 0

                a, b = zaciatok[0], zaciatok[1]
                
                pom = []
                pocet = 0
##                while a != x or b != y:
##                    a += smer_x
##                    b += smer_y
##                    pocet += 1
##                    print(pocet)
##                    if plocha[a][b] != '-':
##                        pom.append(plocha[a][b])
##                        print('a, b, pom:', a, b, pom)
##                if '-' not in pom and pom != [] and len(pom) == pocet - 1:
##                    dobre_zaciatky.append(zaciatok)

                while a != x or b != y:
                    a += smer_x
                    b += smer_y
                    pocet += 1
                    #print(pocet)
                    if plocha[a][b] != '-':
                        pom.append(plocha[a][b])
                        #print('a, b, pom:', a, b, pom)
                if '-' not in pom and pom != [] and len(pom) == pocet - 1 and hrac.znak not in pom:
                    dobre_zaciatky.append(zaciatok)

        #print(hrac.znak, 'dobre zaciatky:',  dobre_zaciatky)

        for zaciatok in dobre_zaciatky:
            if x - zaciatok[0] > 0:
                smer_x = 1
            elif x - zaciatok[0] < 0:
                smer_x = -1
            elif x == zaciatok[0]:
                smer_x = 0
            if y - zaciatok[1] > 0:
                smer_y = 1
            elif y - zaciatok[1] < 0:
                smer_y = -1
            elif y == zaciatok[1]:
                smer_y = 0

            a, b = zaciatok[0], zaciatok[1]
            while a != x or b != y:
                #print('cyklus', a, b)
                a += smer_x
                b += smer_y
                if plocha[a][b] == hrac.znak:
                    break
                plocha[a][b] = hrac.znak
            #print('koniec:', a, b)
            #print(plocha)
        #time.sleep(1)
        if plocha is self.plocha:
            self.update()

    
    def smer(self, x, y):
        vysl = []
        for i in range(8):
            for j in range(8):
                if i - j == x - y:
                    vysl.append([i, j])
                if i + j == x + y:
                    vysl.append([i, j])
                if j == y:
                    vysl.append([i, j])
                if i == x:
                    vysl.append([i, j])
        
        return vysl


##    def vymysli(self):
##        self.pocet = 0
##        moznosti = self.moznosti(self.pocitac, self.plocha)
##                
##        #print('moznosti pc:', self.moznosti(self.pocitac, plocha))
##
##        self.potvrd = True
##        if moznosti == []:
##            print('pocitac nema tah')
##        else:
##            v = []
##            x = self.kopia_plochy(self.plocha)
##            for moznost in moznosti:
##                self.sprav_tah(self.pocitac, x, moznost[0], moznost[1])
##                if self.vymysli_rek(x, self.clovek) is None:
##                    continue
##                v.append(self.vymysli_rek(x, self.clovek))
##            if v != []:
##                vysl = max(v)
##                print(vysl, v)
##            else:
##                print('nic')
##                
##
##    def vymysli_rek(self, plocha, hrac):
##        if hrac is self.clovek:
##            protihrac = self.pocitac
##        else:
##            protihrac = self.clovek
##
##        x = self.kopia_plochy(plocha)
##        moznosti = self.moznosti(hrac, x)
##        #print(moznosti)
##        if self.koniec(x):
##            print('koniec')
##            return 1
##        
##            v = []
##            for moznost in moznosti:
##                if self.sprav_tah(hrac, x, moznost[0], moznost[1]) is not False:
##                    self.sprav_tah(hrac, x, moznost[0], moznost[1])
##                    if self.vymysli_rek(x, protihrac) is None:
##                        continue
##                    v.append(self.vymysli_rek(x, protihrac))
##            print(v)
##            
##
##            if v != []:
##                return sum(v)
##            else:
##                return 0
            

    def vyber(self):
        def na_hrane(x, y):
            return (x == 0 and y == 0) or (x == 0 and y == 7) or (x == 7 and y == 0) or (x == 7 and y == 7)
        self.potvrd = False
        body = []
        moznosti = self.moznosti(self.pocitac, self.plocha)
        #print('moznosti:', moznosti)
        for moznost in moznosti:

            if na_hrane(moznost[0], moznost[1]):
                return self.sprav_tah(self.pocitac, self.plocha, moznost[0], moznost[1])
            
            plocha = [['-' for i in range(8)] for j in range(8)]   #plocha je kopia plochy
            for i in range(8):
                for j in range(8):
                    plocha[i][j] = self.plocha[i][j]
            self.sprav_tah(self.pocitac, plocha, moznost[0], moznost[1])
            b = 0
            for i in range(8):
                for j in range(8):
                    if plocha[i][j] != self.plocha[i][j]:
                        b += 1
            body.append(b)
        self.potvrd = True
        if body == []:
            if not self.koniec(self.plocha):
                print('Pocitac nema tah')
                if self.zaznac_zle:
                    if self.zle_je:
                        pass
                    else:
                        print('vytvaram nema tah')
                        self.zle = self.Button('PC nemá ťah!', 780, 75, 'red', self.canvas)
                        self.canvas.itemconfig(self.zle, font='arial 18')
                        self.zle_je = True
                self.zaznac_zle = True
            
        else:
            vysl = body.index(max(body))
            #print(moznosti[vysl])
            #time.sleep(1)
            self.sprav_tah(self.pocitac, self.plocha, moznosti[vysl][0], moznosti[vysl][1])
            if self.moznosti(self.clovek, self.plocha) == []:
                print('Nemate mozny tah, ide PC')
                self.vyber()

    def nova_hra(self):
        self.plocha = [['-' for i in range(8)] for j in range(8)]
        #self.clovek = self.Player('C')
        #self.pocitac = self.Player('B')
        self.plocha[3][3], self.plocha[4][4] = self.pocitac.znak, self.pocitac.znak
        self.plocha[3][4], self.plocha[4][3] = self.clovek.znak, self.clovek.znak
        if self.bodka_je:
            self.canvas.delete(self.bodka)
            self.bodka_je = False
        
        
        try:
            self.canvas.delete(self.koniec_button.objekt)
            self.canvas.delete(self.koniec_button.text)
        except:
            pass
        self.rob = False
        self.update()
      


    #-----Canvas

    #-Priestor
    def sedi_x(self, kto, neznama):
        if kto.zaciatok_x < neznama < kto.koniec_x:
            return True
        return False

    def sedi_y(self, kto, neznama):
        if kto.zaciatok_y < neznama < kto.koniec_y:
            return True
        return False

    def sedi(self, kto, event):
        return self.sedi_x(kto, event.x) and self.sedi_y(kto, event.y)

    def v_hre(self):
        self.bodka_je = False
        self.zaznac_zle, self.zle_je = False, False
        self.canvas.delete('all')
        self.hram, self.vmenu = True, False
        self.stvorce = self.Stvorec(self.sirka / 4, self.vyska / 6, 75, self.canvas)
        self.v_hre_exit = self.Button_Exit(self.canvas)
        self.nova_hra_button = self.Button('Nová hra', 20, 50, 'OliveDrab1', self.canvas)
        self.skore_napis_pocitac = self.canvas.create_text(75, self.vyska / 6, text='Počítač:', font='arial 20 bold')
        self.skore_napis_clovek = self.canvas.create_text(75, self.vyska / 6 + 75 * 4, text='Hráč:', font='arial 20 bold')

        self.skore_pocitac = self.canvas.create_text(75, self.vyska / 6 + 75, text=str(self.skore(self.plocha)['pocitac']), font='arial 30 bold')
        self.skore_clovek = self.canvas.create_text(75, self.vyska / 6 + 75 * 5, text=str(self.skore(self.plocha)['clovek']), font='airal 30 bold')
        pomocna = self.stvorce
        for i in range(8):
            for j in range(8):
                if i == 0 and j == 0:
                    continue
                pomocna.next = self.Stvorec(self.sirka / 4 + 75 * i, self.vyska / 6 + 75 * j, 75, self.canvas)
                pomocna = pomocna.next

    def v_menu(self):
        self.canvas.delete('all')
        self.vmenu, self.hram, self.vako, self.vskore = True, False, False, False
        self.hraj_button = self.Button('Hraj!', 100, 150, 'red', self.canvas)
        self.ako_button = self.Button('Ako hrať?', 300, 150, 'violet', self.canvas)
        self.skore_button = self.Button('Skóre', 500, 150, 'lightblue', self.canvas)
        self.zavri_button = self.Button('Exit', 700, 100, 'darkred', self.canvas)


    def v_ako(self):

        def uprav_riadok(string):
            vysl = ''
            a = list(string)
            for i in range(len(a)):
                vysl += a[i]
                if i % 40 == 0 and i != 0:
                    vysl += '\n'
            return vysl
        
        self.canvas.delete('all')
        self.vako, self.vmenu, self.hram, self.vskore = True, False, False, False
        self.v_hre_exit = self.Button_Exit(self.canvas)

        x = 250
        y = 50
        i = 1
        with open('ako_obsah.txt', 'r') as subor:
            for riadok in subor:
                if len(riadok) > 15:
                    riadok = uprav_riadok(riadok)
                if i % 2 == 1:
                    self.canvas.create_text(x, y + i * 150, text=riadok, font='arial 30 bold')
                else:
                    self.canvas.create_text(x + 300, y + i * 150, text=riadok, font='arial 20')
                i += 1
        

    def v_skore(self):
        self.canvas.delete('all')
        self.vskore, self.vako, self.vmenu, self.hram = True, False, False, False
        self.v_hre_exit = self.Button_Exit(self.canvas)

        try:

            with open('skore_obsah.txt', 'r') as subor:
                cely = subor.read()
            x = cely.split('\n')
            cisla = [int(x[i].split()[0]) for i in range(len(x))]
            #print('cisla:', cisla)
            mena = [x[i].split()[1] for i in range(len(x))]

            def vymen(zoz, i, j):
                zoz[i], zoz[j] = zoz[j], zoz[i]

            def bubble_sort(zoz, zoz2):
                for i in range(len(zoz)):
                    for j in range(len(zoz)-1):
                        if zoz[j] < zoz[j+1]:
                            vymen(zoz, j, j+1)
                            vymen(zoz2, j, j+1)

            bubble_sort(cisla, mena)

            vysl = ''
            if len(cisla) > 10:
                dlzka = 10
            else:
                dlzka = len(cisla)
            
            for i in range(dlzka):
                vysl += str(cisla[i]) + ' ' + mena[i] + '\n'

            self.canvas.create_text(self.sirka / 2, self.vyska / 2, text=vysl, font='arial 30')

        except:
            self.canvas.create_text(self.sirka / 2, self.vyska / 2, text='Nenašlo sa žiadne skóre', font='arial 30')

        self.canvas.create_text(200, 300, text='Top 10 hier:', font='arial 40 bold')
                       

        

        


    def skonci(self):
        
        if self.skore(self.plocha)['pocitac'] > self.skore(self.plocha)['clovek']:
            text = 'Prehrali Ste!'
            self.koniec_button = self.Button(text, self.vyska / 4 + 50, self.vyska / 5 + 50, 'violet', self.canvas)
        else:
            text = 'Vyhrali Ste!'

##            root = tkinter.Tk()
##            kanvas = tkinter.Canvas(root)
##            kanvas.pack()
##            kanvas.mainloop()
                    

##            konfetta = tkinter.PhotoImage(file='confetti.png')
##
##            self.konfetta1 = self.canvas.create_image(self.sirka / 4, -300, image=konfetta)
##            self.konfetta2 = self.canvas.create_image((self.sirka / 4 )* 3, -300, image=konfetta)
##            self.rob = True
##
##            x, y = self.sirka / 4, -300
##            xi, yi= 20, 20
##            while self.rob:
##                self.canvas.coords(self.konfetta1, x + xi, y + yi)
##                xi *= -1
##                time.sleep(0.5)

            self.koniec_button = self.Button(text, self.vyska / 4 + 50, self.vyska / 5 + 50, 'violet', self.canvas)

            def skus():
                try:
                    with open('skore_obsah.txt', 'r') as subor:
                        print('dobre')
                        return 1
                except:
                    print('zle')
                    return 0

            def sprav():
                meno = e.get()

                if skus():
                    print('toto')
                    vysl = '\n' + str(self.skore(self.plocha)['clovek']) + ' ' + meno
                else:
                    print('a ci hento')
                    vysl = str(self.skore(self.plocha)['clovek']) + ' ' + meno
                
                with open('skore_obsah.txt', 'a') as subor:
                    subor.write(vysl)

                root.quit()
                root.destroy()

            root = tkinter.Tk()
        
            label = Label(root, text="Zadaj meno:")
            e = Entry(root)
            button = Button(root, text="Potvrď!", command=sprav)

            label.grid(row=0, column=0)
            e.grid(row=0, column=1)
            button.grid(row=1, column=0)
        
            root.mainloop()
                
        

    #-Funckie

    def klik(self, event):
        i, j = self.prevod(event.x, event.y)
        print('klik', event.x, event.y, i, j)

        if self.vskore:

            if self.sedi(self.v_hre_exit, event):
                self.v_menu()

        if self.vako:
            
            if self.sedi(self.v_hre_exit, event):
                self.v_menu()

        if self.vmenu:

            if self.sedi(self.skore_button, event):
                self.v_skore()

            if self.sedi(self.hraj_button, event):
                self.v_hre()
                self.update()

            if self.sedi(self.ako_button, event):
                self.v_ako()

            if self.sedi(self.zavri_button, event):
                self.root.quit()
                self.root.destroy()

        if self.hram:

            if self.sedi(self.v_hre_exit, event):
                self.v_menu()

            elif self.sedi(self.nova_hra_button, event):
                self.nova_hra()

            elif self.sirka / 4 < event.x < self.sirka / 4 + 75 * 8 and self.vyska / 6 < event.y < self.vyska / 6 + 75 * 8:
            
                self.potvrd = False
                if self.sprav_tah(self.clovek, self.plocha, i, j) is not False:
                    
                    self.sprav_tah(self.clovek, self.plocha, i, j)
                    self.vyber()
                    #print(self.pocet)
                    if self.koniec(self.plocha):
                        self.skonci()
                else:
                    if self.zaznac_zle:
                        if self.zle_je:
                            pass
                        else:
                            print('vytvaram')
                            self.zle = self.Button('Zlý ťah!', 800, 75, 'red', self.canvas)
                            self.zle_je = True
                    self.zaznac_zle = True
                    
        
    

    def pomoz(self, pomocna):
        if pomocna.x - (self.sirka // 4) == 0:
            i = 0
        else:
            i = int((pomocna.x - (self.sirka // 4)) // pomocna.r)
        if pomocna.y - (self.vyska // 6) == 0:
            j = 0
        else:
            j = int((pomocna.y - (self.vyska // 6)) // pomocna.r)
        return i, j

    def prevod(self, x, y):
        if x - (self.sirka // 4) == 0:
            i = 0
        else:
            i = int((x - (self.sirka // 4)) // 75)
        if y - (self.vyska // 6) == 0:
            j = 0
        else:
            j = int((y - (self.vyska // 6)) // 75)
        return i, j

    def update(self):
        pomocna = self.stvorce
        while pomocna:
            i, j = self.pomoz(pomocna)
            if self.plocha[i][j] == 'B':
                self.canvas.itemconfig(pomocna.objekt, fill='white')
            elif self.plocha[i][j] == 'C':
                self.canvas.itemconfig(pomocna.objekt, fill='black')
            else:
                self.canvas.itemconfig(pomocna.objekt, fill=pomocna.farba)
            pomocna = pomocna.next

        self.canvas.itemconfig(self.skore_pocitac, text=str(self.skore(self.plocha)['pocitac']))
        self.canvas.itemconfig(self.skore_clovek, text=str(self.skore(self.plocha)['clovek']))

        try:
            self.canvas.delete(self.zle.objekt)
            self.canvas.delete(self.zle.text)
            self.zle_je = False
        except:
            pass


        if self.potvrd == True:
            time.sleep(1)
        self.canvas.update()

    def oznac(self, x, y):
        pomocna = self.stvorce
        while pomocna:
            i, j = self.pomoz(pomocna)
            if i == x and j == y:
                najdena = pomocna
            pomocna = pomocna.next

        pol = 30
        coord = [najdena.x + pol, najdena.y + pol, najdena.x + najdena.r - pol, najdena.y + najdena.r - pol]

        if self.bodka_je:
            self.canvas.coords(self.bodka, coord)
        else:
            self.bodka = self.canvas.create_oval(coord, fill='red')
            self.bodka_je = True
            
##        try:
##            self.canvas.coords(self.bodka, coord)
##        except:
##            self.bodka = self.canvas.create_oval(coord, fill='red')

        

    


hra = Othello()
