package com.company;

import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;

public class HTMLParser {

    String html1 = "https://varecha.pravda.sk/recepty/bryndzove-pirohy-so-slaninkou-fotorecept-/75552-recept.html";
    String html2 = "https://varecha.pravda.sk/recepty/makove-rezance-mojej-babicky-fotorecept/75998-recept.html";
    String html3 = "https://varecha.pravda.sk/recepty/kremova-polievka-z-tekvice-hokkaido/76006-recept.html";
    String html4 = "https://varecha.pravda.sk/recepty/kuracie-prsia-s-ryzou-a-bazalkou-fotorecept/75446-recept.html";

    public HTMLParser(){ }

    public void writeData() throws IOException {
        FileWriter fileWriter = new FileWriter("/home/iveta/Plocha/bakalarka_repozitarReceprovVSietiPrepojenychDat/recipe/src/com/company/recipes1.owl");
        fileWriter.write(ontology);

        getDataAbout(this.html1, fileWriter);
        getDataAbout(this.html2, fileWriter);
        getDataAbout(this.html3, fileWriter);
        getDataAbout(this.html4, fileWriter);

        fileWriter.write("</rdf:RDF>");
        fileWriter.close();
    }

    public void getDataAbout(String html, FileWriter fileWriter) throws IOException {
        Document doc = Jsoup.connect(html).get();

        Elements suroviny = doc.select(".recipe-ingredients__ingredient");
        Elements postup = doc.select(".recipe-instruction__main > p");
        Elements nazov = doc.select("h1");

        String recept = html.substring(html.indexOf("-recept") - 5, html.indexOf("-recept") + 7);

        String porcie = "";

        Elements cisla = doc.select(".info-number");

        for (Element e : cisla) {
            if(e.text().contains("porcie")){
                porcie=e.text().replace("porcie", "");
            }
        }

        //vytvorit recept
        fileWriter.write("<owl:NamedIndividual rdf:about=\"http://www.semanticweb.org/iveta/ontologies/2020/0/untitled-ontology-18#");
        fileWriter.write(recept);
        fileWriter.write("\">\n");

        fileWriter.write("<rdf:type rdf:resource=\"http://www.semanticweb.org/iveta/ontologies/2020/0/untitled-ontology-18#Recipe\"/>\n");

        //nazov
        fileWriter.write("<hasName>");
        fileWriter.write(nazov.text());
        fileWriter.write("</hasName>\n");

        //postup
        fileWriter.write("<hasDescription>");
        for (Element e : postup) {
            fileWriter.write(e.text());
        }
        fileWriter.write("</hasDescription>\n");

        //suroviny
        for (Element e : suroviny) {
            fileWriter.write("<hasIngredient rdf:resource=");
            fileWriter.write("\"http://www.semanticweb.org/iveta/ontologies/2020/0/untitled-ontology-18#");
            fileWriter.write(e.text().replace(' ', '_'));
            fileWriter.write("\"/>\n");
        }

        //porcie
        if(!porcie.equals("")){
            fileWriter.write("<portion rdf:datatype=\"http://www.w3.org/2001/XMLSchema#string\">");
            fileWriter.write(porcie);
            fileWriter.write("</portion>\n");
        }
        fileWriter.write("</owl:NamedIndividual>\n");

        //vytvorit suroviny
        for (Element e : suroviny) {
            fileWriter.write("<owl:NamedIndividual rdf:about=\"http://www.semanticweb.org/iveta/ontologies/2020/0/untitled-ontology-18#");
            fileWriter.write(e.text().replace(' ', '_'));
            fileWriter.write("\">\n");
            fileWriter.write("<rdf:type rdf:resource=\"http://www.semanticweb.org/iveta/ontologies/2020/0/untitled-ontology-18#Ingredient\"/>\n");
            fileWriter.write("<hasName>");
            fileWriter.write(e.text().replace(' ', '_'));
            fileWriter.write("</hasName>\n");
            fileWriter.write("</owl:NamedIndividual>\n");
        }
    }

    String ontology = "<?xml version=\"1.0\"?>\n" +
            "<rdf:RDF xmlns=\"http://www.semanticweb.org/iveta/ontologies/2020/0/untitled-ontology-18#\"\n" +
            "     xml:base=\"http://www.semanticweb.org/iveta/ontologies/2020/0/untitled-ontology-18\"\n" +
            "     xmlns:owl=\"http://www.w3.org/2002/07/owl#\"\n" +
            "     xmlns:rdf=\"http://www.w3.org/1999/02/22-rdf-syntax-ns#\"\n" +
            "     xmlns:xml=\"http://www.w3.org/XML/1998/namespace\"\n" +
            "     xmlns:xsd=\"http://www.w3.org/2001/XMLSchema#\"\n" +
            "     xmlns:rdfs=\"http://www.w3.org/2000/01/rdf-schema#\">\n" +
            "    <owl:Ontology rdf:about=\"http://www.semanticweb.org/iveta/ontologies/2020/0/untitled-ontology-18\"/>\n" +
            "    \n" +
            "\n" +
            "\n" +
            "    <!-- \n" +
            "    ///////////////////////////////////////////////////////////////////////////////////////\n" +
            "    //\n" +
            "    // Object Properties\n" +
            "    //\n" +
            "    ///////////////////////////////////////////////////////////////////////////////////////\n" +
            "     -->\n" +
            "\n" +
            "    \n" +
            "\n" +
            "\n" +
            "    <!-- http://www.semanticweb.org/iveta/ontologies/2020/0/untitled-ontology-18#hasAnAuthor -->\n" +
            "\n" +
            "    <owl:ObjectProperty rdf:about=\"http://www.semanticweb.org/iveta/ontologies/2020/0/untitled-ontology-18#hasAnAuthor\">\n" +
            "        <rdfs:domain rdf:resource=\"http://www.semanticweb.org/iveta/ontologies/2020/0/untitled-ontology-18#Recipe\"/>\n" +
            "        <rdfs:range rdf:resource=\"https://schema.org/Person\"/>\n" +
            "    </owl:ObjectProperty>\n" +
            "    \n" +
            "\n" +
            "\n" +
            "    <!-- http://www.semanticweb.org/iveta/ontologies/2020/0/untitled-ontology-18#hasIngredient -->\n" +
            "\n" +
            "    <owl:ObjectProperty rdf:about=\"http://www.semanticweb.org/iveta/ontologies/2020/0/untitled-ontology-18#hasIngredient\">\n" +
            "        <rdfs:domain rdf:resource=\"http://www.semanticweb.org/iveta/ontologies/2020/0/untitled-ontology-18#Recipe\"/>\n" +
            "        <rdfs:range rdf:resource=\"http://www.semanticweb.org/iveta/ontologies/2020/0/untitled-ontology-18#Ingredient\"/>\n" +
            "    </owl:ObjectProperty>\n" +
            "    \n" +
            "\n" +
            "\n" +
            "    <!-- \n" +
            "    ///////////////////////////////////////////////////////////////////////////////////////\n" +
            "    //\n" +
            "    // Data properties\n" +
            "    //\n" +
            "    ///////////////////////////////////////////////////////////////////////////////////////\n" +
            "     -->\n" +
            "\n" +
            "    \n" +
            "\n" +
            "\n" +
            "    <!-- http://www.semanticweb.org/iveta/ontologies/2020/0/untitled-ontology-18#cookTime -->\n" +
            "\n" +
            "    <owl:DatatypeProperty rdf:about=\"http://www.semanticweb.org/iveta/ontologies/2020/0/untitled-ontology-18#cookTime\">\n" +
            "        <rdfs:domain rdf:resource=\"http://www.semanticweb.org/iveta/ontologies/2020/0/untitled-ontology-18#Recipe\"/>\n" +
            "        <rdfs:range rdf:resource=\"http://www.w3.org/2001/XMLSchema#integer\"/>\n" +
            "    </owl:DatatypeProperty>\n" +
            "    \n" +
            "\n" +
            "\n" +
            "    <!-- http://www.semanticweb.org/iveta/ontologies/2020/0/untitled-ontology-18#hasDescription -->\n" +
            "\n" +
            "    <owl:DatatypeProperty rdf:about=\"http://www.semanticweb.org/iveta/ontologies/2020/0/untitled-ontology-18#hasDescription\">\n" +
            "        <rdfs:domain rdf:resource=\"http://www.semanticweb.org/iveta/ontologies/2020/0/untitled-ontology-18#Recipe\"/>\n" +
            "        <rdfs:range rdf:resource=\"http://www.w3.org/2001/XMLSchema#string\"/>\n" +
            "    </owl:DatatypeProperty>\n" +
            "    \n" +
            "\n" +
            "\n" +
            "    <!-- http://www.semanticweb.org/iveta/ontologies/2020/0/untitled-ontology-18#hasName -->\n" +
            "\n" +
            "    <owl:DatatypeProperty rdf:about=\"http://www.semanticweb.org/iveta/ontologies/2020/0/untitled-ontology-18#hasName\">\n" +
            "        <rdfs:domain rdf:resource=\"http://www.semanticweb.org/iveta/ontologies/2020/0/untitled-ontology-18#Ingredient\"/>\n" +
            "        <rdfs:domain rdf:resource=\"http://www.semanticweb.org/iveta/ontologies/2020/0/untitled-ontology-18#Recipe\"/>\n" +
            "        <rdfs:range rdf:resource=\"http://www.w3.org/2001/XMLSchema#string\"/>\n" +
            "    </owl:DatatypeProperty>\n" +
            "    \n" +
            "\n" +
            "\n" +
            "    <!-- http://www.semanticweb.org/iveta/ontologies/2020/0/untitled-ontology-18#portion -->\n" +
            "\n" +
            "    <owl:DatatypeProperty rdf:about=\"http://www.semanticweb.org/iveta/ontologies/2020/0/untitled-ontology-18#portion\">\n" +
            "        <rdfs:domain rdf:resource=\"http://www.semanticweb.org/iveta/ontologies/2020/0/untitled-ontology-18#Recipe\"/>\n" +
            "        <rdfs:range rdf:resource=\"http://www.w3.org/2001/XMLSchema#string\"/>\n" +
            "    </owl:DatatypeProperty>\n" +
            "    \n" +
            "\n" +
            "\n" +
            "    <!-- https://schema.org/alternateName -->\n" +
            "\n" +
            "    <owl:DatatypeProperty rdf:about=\"https://schema.org/alternateName\">\n" +
            "        <rdfs:domain rdf:resource=\"https://schema.org/Person\"/>\n" +
            "        <rdfs:range rdf:resource=\"http://www.w3.org/2001/XMLSchema#string\"/>\n" +
            "    </owl:DatatypeProperty>\n" +
            "    \n" +
            "\n" +
            "\n" +
            "    <!-- \n" +
            "    ///////////////////////////////////////////////////////////////////////////////////////\n" +
            "    //\n" +
            "    // Classes\n" +
            "    //\n" +
            "    ///////////////////////////////////////////////////////////////////////////////////////\n" +
            "     -->\n" +
            "\n" +
            "    \n" +
            "\n" +
            "\n" +
            "    <!-- http://www.semanticweb.org/iveta/ontologies/2020/0/untitled-ontology-18#Ingredient -->\n" +
            "\n" +
            "    <owl:Class rdf:about=\"http://www.semanticweb.org/iveta/ontologies/2020/0/untitled-ontology-18#Ingredient\"/>\n" +
            "    \n" +
            "\n" +
            "\n" +
            "    <!-- http://www.semanticweb.org/iveta/ontologies/2020/0/untitled-ontology-18#Recipe -->\n" +
            "\n" +
            "    <owl:Class rdf:about=\"http://www.semanticweb.org/iveta/ontologies/2020/0/untitled-ontology-18#Recipe\"/>\n" +
            "    \n" +
            "\n" +
            "\n" +
            "    <!-- https://schema.org/Person -->\n" +
            "\n" +
            "    <owl:Class rdf:about=\"https://schema.org/Person\"/>\n";

}

