package com.company;

import org.apache.jena.query.*;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.util.FileManager;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class Main extends Menu{

    @Override
    public void print() {
        System.out.println("************************************************");
        System.out.println("* 1. get all name of recipes                   *");
        System.out.println("* 2. get information about recipe with name    *");
        System.out.println("* 3. get recipe with ingredient                *");
        System.out.println("* 4. exit                                      *");
        System.out.println("************************************************");
    }

    public static void main(String[] args) throws IOException {
        Main mainMenu = new Main();
        HTMLParser htmlParser = new HTMLParser();
        htmlParser.writeData();
        mainMenu.run();
    }

    @Override
    public void handle(String option) throws IOException{
        switch (option) {
            case "1":   getAllRecipes(); break;
            case "2":   getInformationAbout(); break;
            case "3":   getRecipeWithIngredients(); break;
            case "4":   exit(); break;
            default:    System.out.println("Unknown option"); break;
        }
    }


    public static void getAllRecipes(){
        FileManager.get().addLocatorClassLoader(Main.class.getClassLoader());
        Model model = FileManager.get().loadModel("/home/iveta/Plocha/bakalarka_repozitarReceprovVSietiPrepojenychDat/recipe/src/com/company/recipes1.owl");

        String queryString =
                "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>" +
                        "PREFIX my: <http://www.semanticweb.org/iveta/ontologies/2020/0/untitled-ontology-18#>" +
                        "SELECT ?name WHERE {" +
                        "?x a my:Recipe." +
                        "?x my:hasName ?name." +
                        "}";
        Query query = QueryFactory.create(queryString);
        QueryExecution qexec = QueryExecutionFactory.create(query, model);
        try{
            ResultSet result = qexec.execSelect();
            while (result.hasNext()){
                QuerySolution sol = result.nextSolution();
                Literal name = sol.getLiteral("name");
                System.out.println(name);
            }

        } finally {
            qexec.close();
        }
    }

    public static void getInformationAbout() throws IOException {
        FileManager.get().addLocatorClassLoader(Main.class.getClassLoader());
        Model model = FileManager.get().loadModel("/home/iveta/Plocha/bakalarka_repozitarReceprovVSietiPrepojenychDat/recipe/src/com/company/recipes1.owl");

        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Enter name: ");
        String nameFromInput = br.readLine();

        String queryString =
                "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>" +
                        "PREFIX my: <http://www.semanticweb.org/iveta/ontologies/2020/0/untitled-ontology-18#>" +
                        "PREFIX schema: <http://schema.org/>" +
                        "SELECT ?name ?ingredientName ?portion ?description WHERE {" +
                        "?x a my:Recipe;" +
                        "my:hasName ?name;" +
                        "my:hasDescription ?description;" +
                    //    "my:hasAuthor ?author1;" +
                        "my:hasIngredient ?ingredient." +
                        "?ingredient my:hasName ?ingredientName;" +
                        //    "?author1 schema:alternateName ?author." +
                        "filter (?name = \"" + nameFromInput + "\")" +
                        "OPTIONAL {?x my:portion ?portion. }" +
                        "}" ;
        Query query = QueryFactory.create(queryString);
        QueryExecution qexec = QueryExecutionFactory.create(query, model);
        try{

            ResultSet result = qexec.execSelect();

            boolean first = true;
            while (result.hasNext()){
                QuerySolution sol = result.nextSolution();

                if(first){
                    Literal name = sol.getLiteral("name");
                    Literal portion = sol.getLiteral("portion");
                    Literal description = sol.getLiteral("description");
                    Literal ingredientName = sol.getLiteral("ingredientName");
                    System.out.println(name);
                    System.out.println("Porcie: " + portion);
                    System.out.println("Popis: " + description);
                    System.out.print("Ingrediencia: " + ingredientName + ", ");
                    first = false;
                } else {
                    Literal ingredientName = sol.getLiteral("ingredientName");
                    System.out.print(ingredientName + ", ");
                }
            }

        } finally {
            System.out.println("Recipe doesnt exist");
            qexec.close();
        }

    }

    public static void getRecipeWithIngredients() throws IOException {

        FileManager.get().addLocatorClassLoader(Main.class.getClassLoader());
        Model model = FileManager.get().loadModel("/home/iveta/Plocha/bakalarka_repozitarReceprovVSietiPrepojenychDat/recipe/src/com/company/recipes1.owl");

        BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
        System.out.println("Enter ingredient: ");
        String nameFromInput = br.readLine();

        String queryString =
                "PREFIX rdf: <http://www.w3.org/1999/02/22-rdf-syntax-ns#>" +
                        "PREFIX my: <http://www.semanticweb.org/iveta/ontologies/2020/0/untitled-ontology-18#>" +
                        "SELECT ?name ?recipe WHERE {" +
                        "?recipe a my:Recipe;" +
                        "my:hasName ?name;" +
                        "my:hasIngredient ?ingr." +
                        "?ingr my:hasName \"" + nameFromInput + "\"."  +
                        "}";

        Query query = QueryFactory.create(queryString);
        QueryExecution qexec = QueryExecutionFactory.create(query, model);
        try{

            ResultSet result = qexec.execSelect();
            while (result.hasNext()){
                QuerySolution sol = result.nextSolution();
                Literal name = sol.getLiteral("name");
                System.out.println(name);
                System.out.println(sol.get("recipe"));
            }

        } finally {
            qexec.close();
        }

    }

}
