package source

import Edge
import Graph
import Vertex
import java.io.PrintWriter

/**
 * Minimal asymmetric graphs
 *
 * @constructor
 *
 * @param number
 */
class MinimalAsymmetricGraphs(number: Int = 0) : Graphs(number) {
    private var numberOfMinimalAsymmetricGraphs = 18
    private var listOfMinimalGraphs = mutableListOf<Graph>()

    private fun minimalAsymmetricGraph(numberOfMinimalAsymmetricGraph: Int) {
        val list = mutableListOf<Edge>()
        val edges = mutableListOf<Int>()

        numberOfVertices = if (numberOfMinimalAsymmetricGraph > 14) 8
        else if (numberOfMinimalAsymmetricGraph > 8) 7
        else 6
        makeVerticesAndEdges(numberOfVertices)

        when(numberOfMinimalAsymmetricGraph) {
            1 -> edges.addAll(listOf(0, 6, 10, 12, 13, 14))
            2 -> edges.addAll(listOf(0, 5, 6, 10, 12, 13, 14))
            3 -> edges.addAll(listOf(1, 2, 6, 9, 10, 13, 14))
            4 -> edges.addAll(listOf(1, 6, 9, 10, 11, 13, 14))
            5 -> edges.addAll(listOf(0, 5, 6, 7, 10, 12, 13, 14))
            6 -> edges.addAll(listOf(1, 5, 6, 7, 10, 12, 13, 14))
            7 -> edges.addAll(listOf(0, 1, 6, 9, 10, 11, 13, 14))
            8 -> edges.addAll(listOf(0, 2, 5, 7, 9, 10, 12, 13, 14))
            9 -> edges.addAll(listOf(0, 1, 11, 15, 16, 20))
            10 -> edges.addAll(listOf(0, 1, 11, 12, 16, 18, 19))
            11 -> edges.addAll(listOf(0, 6, 7, 12, 15, 16, 19, 20))
            12 -> edges.addAll(listOf(0, 1, 2, 4, 6, 7, 10, 11, 15, 17, 18, 19, 20))
            13 -> edges.addAll(listOf(0, 1, 2, 3, 4, 6, 7, 10, 11, 15, 17, 18, 19, 20))
            14 -> edges.addAll(listOf(0, 1, 2, 4, 6, 7, 10, 11, 13, 14, 15, 16, 18, 19, 20))
            15 -> edges.addAll(listOf(1, 8, 13, 14, 16, 19, 22, 26, 27))
            16 -> edges.addAll(listOf(0, 7, 8, 11, 14, 18, 19, 24, 25, 27))
            17 -> edges.addAll(listOf(0, 1, 2, 3, 4, 7, 8, 12, 13, 15, 18, 19, 21, 22, 23, 24, 25, 27))
            18 -> edges.addAll(listOf(0, 1, 2, 3, 4, 8, 9, 12, 13, 15, 16, 18, 19, 20, 22, 23, 24, 25, 27))
        }

        for (edge in edges)
            list.add(listOfEdges[edge])

        listOfMinimalGraphs.add(myGraph.createGraph(vertices, list))
        myGraph = myGraph.createGraph(vertices, list)
    }

    /**
     * Make minimal asymmetric graphs
     *
     * @return
     */
    fun makeMinimalAsymmetricGraphs() : List<Graph> {
        val filename = "minasgraphs.txt"
        val writer = PrintWriter(filename)

        for (i in 1..numberOfMinimalAsymmetricGraphs) {
            minimalAsymmetricGraph(i)
            myGraph.writeGraphToFile(writer)
        }

        writer.close()

        println("Minimal asymmetric graphs have been created")
        println("Number of minimal asymmetric graphs is ${listOfMinimalGraphs.size}")
        println("The graphs are stored in a file named $filename")
        return listOfMinimalGraphs
    }

    private fun combinationOfEdges(listOfEdges: MutableList<MutableList<Edge>>, edges: List<Edge>, data: MutableList<Edge>, start: Int, end: Int, index: Int, number: Int) {
        if (index == number) {
            val helpList = mutableListOf<Edge>()
            for (j in 0 until number)
                helpList.add(data[j])
            listOfEdges.add(helpList)
            return
        }

        var i = start
        while (i <= end && end - i + 1 >= number - index) {
            data.add(index, edges[i])
            combinationOfEdges(listOfEdges, edges, data, i + 1, end, index + 1, number)
            i++
        }
    }

    private fun getUndirectedEdges(listOfEdges: List<Edge>): MutableList<Edge> {
        val undirectedEdges = mutableListOf<Edge>()
        for (edge in listOfEdges)
            if (!undirectedEdges.contains(edge) && !undirectedEdges.contains(Edge(Pair(edge.label.second, edge.label.first))))
                undirectedEdges.add(edge)

        return undirectedEdges
    }

    /**
     * Make graphs with removed edge
     *
     * @param number
     * @param from
     * @param to
     */
    fun makeGraphsWithRemovedEdge(number: Int, from: Int = 1, to: Int = numberOfMinimalAsymmetricGraphs) {
        val filename = "minasgraphswithoutedge.txt"
        val writer = PrintWriter(filename)

        for (i in from..to) {
            minimalAsymmetricGraph(i)
            val undirectedListOfEdges = getUndirectedEdges(myGraph.getEdges().toList())
            val data = mutableListOf<Edge>()
            val listOfTheseEdges = mutableListOf<MutableList<Edge>>()
            combinationOfEdges(listOfTheseEdges, undirectedListOfEdges, data, 0, undirectedListOfEdges.size - 1, 0, number)
            for (edges in listOfTheseEdges) {
                var helpGraph = myGraph
                helpGraph = helpGraph.createGraph(myGraph.getVertices().toList(), myGraph.getEdges().toList())
                for (edge in edges)
                    helpGraph.removeEdge(edge)
                var contains = false
                for (graph in listOfGraphs)
                    if (graph.getVertices() == helpGraph.getVertices() && graph.getEdges() == helpGraph.getEdges())
                        contains = true
                if (!contains && helpGraph.isConnected()) {
                    listOfGraphs.add(helpGraph)
                    helpGraph.writeGraphToFile(writer)
                }
            }
        }

        writer.close()

        println("Graphs have been created")
        println("Number of graphs is ${listOfGraphs.size}")
        println("The graphs are stored in a file named $filename")
    }

    private fun combinationOfVertices(listOfVertices: MutableList<MutableList<Vertex>>, vertices: List<Vertex>, data: MutableList<Vertex>, start: Int, end: Int, index: Int, number: Int) {
        if (index == number) {
            val helpList = mutableListOf<Vertex>()
            for (j in 0 until number)
                helpList.add(data[j])
            listOfVertices.add(helpList)
            return
        }

        var i = start
        while (i <= end && end - i + 1 >= number - index) {
            data.add(index, vertices[i])
            combinationOfVertices(listOfVertices, vertices, data, i + 1, end, index + 1, number)
            i++
        }
    }

    /**
     * Make graphs with removed vertex
     *
     * @param number
     * @param from
     * @param to
     */
    fun makeGraphsWithRemovedVertex(number: Int, from: Int = 1, to: Int = numberOfMinimalAsymmetricGraphs) {
        val filename = "minasgraphswithoutvertex.txt"
        val writer = PrintWriter(filename)
        var helpGraph: Graph

        for (i in from..to) {
            minimalAsymmetricGraph(i)
            val data = mutableListOf<Vertex>()
            val listOfVertices = mutableListOf<MutableList<Vertex>>()
            combinationOfVertices(listOfVertices, myGraph.getVertices().toList(), data, 0, myGraph.getVertices().toList().size - 1, 0, number)
            for (vertices in listOfVertices) {
                helpGraph = Graph()
                helpGraph = helpGraph.createGraph(myGraph.getVertices().toList(), myGraph.getEdges().toList())
                for (vertex in vertices)
                    helpGraph.removeVertex(vertex)
                if (helpGraph.getVertices().size == 2 && helpGraph.getEdges().size == 1)
                    helpGraph = helpGraph.createGraph(listOf(Vertex("0"), Vertex("1")), listOf(Edge(Pair(Vertex("0"), Vertex("1")))))
                var contains = false
                for (graph in listOfGraphs) {
                    if (graph.getVertices() == helpGraph.getVertices() && graph.getEdges() == helpGraph.getEdges())
                        contains = true
                }
                if (!contains && helpGraph.isConnected()) {
                    listOfGraphs.add(helpGraph)
                    helpGraph.writeGraphToFile(writer)
                }
            }
        }

        writer.close()

        println("Graphs have been created")
        println("Number of graphs is ${listOfGraphs.size}")
        println("The graphs are stored in a file named $filename")
    }

    /**
     * Make graphs with added edge
     *
     * @param number
     * @param from
     * @param to
     */
    fun makeGraphsWithAddedEdge(number: Int, from: Int = 1, to: Int = numberOfMinimalAsymmetricGraphs) {
        val filename = "minasgraphswithedge.txt"
        val writer = PrintWriter(filename)

        for (i in from..to) {
            minimalAsymmetricGraph(i)
            val data = mutableListOf<Edge>()
            val listOfTheseEdges = mutableListOf<MutableList<Edge>>()
            combinationOfEdges(listOfTheseEdges, listOfEdges, data, 0, listOfEdges.size - 1, 0, number)
            println(i)
            for (edges in listOfTheseEdges) {
                var helpGraph = myGraph
                helpGraph = helpGraph.createGraph(myGraph.getVertices().toList(), myGraph.getEdges().toList())
                var added = true
                for (edge in edges)
                    if (edge in helpGraph.getEdges())
                        added = false
                    else
                        helpGraph.addEdge(edge)
                var contains = false
                for (graph in listOfGraphs)
                    if (graph.getVertices() == helpGraph.getVertices() && graph.getEdges() == helpGraph.getEdges())
                        contains = true
                if (!contains && added) {
                    listOfGraphs.add(helpGraph)
                    helpGraph.writeGraphToFile(writer)
                }
            }
        }

        writer.close()

        println("Graphs have been created")
        println("Number of graphs is ${listOfGraphs.size}")
        println("The graphs are stored in a file named $filename")
    }
}

/**
 * Main
 *
 */
fun main() {
    val minimalAsymmetricGraphs = MinimalAsymmetricGraphs() //makes minimal asymmetric graphs
    //minimalAsymmetricGraphs.makeMinimalAsymmetricGraphs()
    //minimalAsymmetricGraphs.makeGraphsWithRemovedVertex(6, 18, 18)
    //minimalAsymmetricGraphs.makeGraphsWithRemovedEdge(1)
    //for (graph in minimalAsymmetricGraphs.makeMinimalAsymmetricGraphs()) {
    //println(graph.isBipartite())
    //println(graph.primMST())
    //}
    //minimalAsymmetricGraphs.makeGraphsWithAddedEdge(6, 18, 18)
}