import source.Graphs
import source.MinimalAsymmetricGraphs
import java.io.BufferedReader
import java.io.IOException
import java.io.InputStreamReader

/**
 * Main
 *
 * @constructor Create empty Main
 */
class Main {
    private var exit = false
    private var menu = true

    /**
     * Run
     *
     */
    fun run() {
        exit = false
        val br = BufferedReader(InputStreamReader(System.`in`))
        help()
        while (!exit) {
            if (menu)
                print()
            menu = false
            println()
            var line: String
            try {
                line = br.readLine()
                handle(line)
                if (!exit && !menu) {
                    println()
                    println("M. Print menu")
                }
            } catch (e: IOException) {
                println("Unknown error, please, try to restart the application")
            }
        }
    }

    private fun exit() {
        exit = true
    }

    private fun help() {
        println()
        println("Select the option you want to run and enter its number in the console.")
        println("After pressing the \"enter\" key, the result is displayed.")
        println()
    }

    private fun print() {
        println("~~            Graphs            ~~")
        println()
        println("1. Create graph with 1 vertex.    ")
        println("2. Create graphs with 2 vertices. ")
        println("3. Create graphs with 3 vertices. ")
        println("4. Create graphs with 4 vertices. ")
        println("5. Create graphs with 5 vertices. ")
        println("6. Create graphs with 6 vertices. ")
        println()
        println("~~              Minimal asymmetric graphs              ~~")
        println()
        println("7.  Create minimal asymmetric graphs.                    ")
        println("8.  Print if minimal asymmetric graphs are bipartite.    ")
        println("9.  Create minimal asymmetric graphs without 1 vertex.   ")
        println("10. Create minimal asymmetric graphs without 2 vertices. ")
        println("11. Create minimal asymmetric graphs without 3 vertices. ")
        println("12. Create minimal asymmetric graphs without 4 vertices. ")
        println("13. Create minimal asymmetric graphs without 5 vertices. ")
        println("14. Create minimal asymmetric graphs without 1 edge.     ")
        println("15. Create minimal asymmetric graphs without 2 edges.    ")
        println("16. Create minimal asymmetric graphs without 3 edges.    ")
        println("17. Create minimal asymmetric graphs without 4 edges.    ")
        println("18. Create minimal asymmetric graphs without 5 edges.    ")
        println("19. Create minimal asymmetric graphs with 1 more edge.   ")
        println("20. Create minimal asymmetric graphs with 2 more edges.  ")
        println("21. Create minimal asymmetric graphs with 3 more edges.  ")
        println("22. Create minimal asymmetric graphs with 4 more edges.  ")
        println("23. Create minimal asymmetric graphs with 5 more edges.  ")
        println()
        println("E.  exit")
    }

    private fun handle(option: String) {
        val graphs = arrayListOf<Graphs>()
        for (numberOfVertices in 1..6)
            graphs.add(Graphs(numberOfVertices))
        val minimalAsymmetricGraphs = MinimalAsymmetricGraphs()
        try {
            when (option) {
                "1" -> graphs[0].makeGraphs()
                "2" -> graphs[1].makeGraphs()
                "3" -> graphs[2].makeGraphs()
                "4" -> graphs[3].makeGraphs()
                "5" -> graphs[4].makeGraphs()
                "6" -> graphs[5].makeGraphs()
                "7" -> minimalAsymmetricGraphs.makeMinimalAsymmetricGraphs()
                "8" -> for (graph in minimalAsymmetricGraphs.makeMinimalAsymmetricGraphs())
                    println(graph.isBipartite())
                "9" -> minimalAsymmetricGraphs.makeGraphsWithRemovedVertex(1)
                "10" -> minimalAsymmetricGraphs.makeGraphsWithRemovedVertex(2)
                "11" -> minimalAsymmetricGraphs.makeGraphsWithRemovedVertex(3)
                "12" -> minimalAsymmetricGraphs.makeGraphsWithRemovedVertex(4)
                "13" -> minimalAsymmetricGraphs.makeGraphsWithRemovedVertex(5)
                "14" -> minimalAsymmetricGraphs.makeGraphsWithRemovedEdge(1)
                "15" -> minimalAsymmetricGraphs.makeGraphsWithRemovedEdge(2)
                "16" -> minimalAsymmetricGraphs.makeGraphsWithRemovedEdge(3)
                "17" -> minimalAsymmetricGraphs.makeGraphsWithRemovedEdge(4)
                "18" -> minimalAsymmetricGraphs.makeGraphsWithRemovedEdge(5)
                "19" -> minimalAsymmetricGraphs.makeGraphsWithAddedEdge(1)
                "20" -> minimalAsymmetricGraphs.makeGraphsWithAddedEdge(2)
                "21" -> minimalAsymmetricGraphs.makeGraphsWithAddedEdge(3)
                "22" -> minimalAsymmetricGraphs.makeGraphsWithAddedEdge(4)
                "23" -> minimalAsymmetricGraphs.makeGraphsWithAddedEdge(5)
                "e" -> exit()
                "E" -> exit()
                "m" -> menu = true
                "M" -> menu = true
                else -> println("Unknown option")
            }
        } catch (e: IOException) {
            println(e)
            run()
        }
    }
}

/**
 * Main
 *
 */
fun main() {
    val main = Main()
    main.run()
}