package source

import Edge
import Graph
import Vertex
import java.io.PrintWriter
import kotlin.math.pow

/**
 * Graphs
 *
 * @constructor
 *
 * @param number
 */
open class Graphs(number: Int) : Graph() {
    var numberOfVertices = 0
    var myGraph = Graph()
    var vertices: MutableList<Vertex> = mutableListOf()
    var listOfEdges = mutableListOf<Edge>()
    var listOfGraphs = mutableListOf<Graph>()

    init {
        numberOfVertices = number
    }

    /**
     * Make vertices and edges
     *
     * @param numberOfVertices
     */
    fun makeVerticesAndEdges(numberOfVertices: Int) {
        myGraph = Graph()
        vertices = mutableListOf()
        listOfEdges = mutableListOf()

        for (vertex1 in 0 until numberOfVertices) {
            vertices.add(Vertex(vertex1.toString()))
            for (vertex2 in vertex1+1 until numberOfVertices)
                listOfEdges.add(Edge(Pair(Vertex(vertex1.toString()), Vertex(vertex2.toString()))))
        }
    }

    /**
     * Make graphs
     *
     */
    fun makeGraphs() {
        listOfGraphs = mutableListOf()
        makeVerticesAndEdges(numberOfVertices)

        val powSetSize = 2.0.pow(listOfEdges.size).toInt()
        val writer = PrintWriter("graphsingapsyntax.txt")

        for (counter in 0 until powSetSize) {
            val list = mutableListOf<Edge>()
            for (edge in 0 until listOfEdges.size) {
                if (counter and (1 shl edge) > 0)
                    list.add(listOfEdges[edge])
            }
            listOfGraphs.add(myGraph.createGraph(vertices, list))
            myGraph.writeGraphToFile(writer)
        }

        writer.close()

        if (numberOfVertices > 1)
            println("Graphs with $numberOfVertices vertices have been created")
        else
            println("Graph with $numberOfVertices vertex has been created")
        println("Number of graphs with $numberOfVertices vertices is ${listOfGraphs.size}")
    }
}

/**
 * Main
 *
 * @param args
 */
fun main(args: Array<String>) {
    if (args.isEmpty()) {
        print("Please add number of vertices (command line arguments)")
        return
    }

    val graphsSix = Graphs(args[5].toInt()) //make graphs with 6 vertices
    graphsSix.makeGraphs()
    //val graphsSeven = Graphs(args[6].toInt()) //make graphs with 7 vertices
    //graphsSeven.makeGraphs()
    //val graphsEight = Graphs(args[7].toInt()) //make graphs with 8 vertices
    //graphsEight.makeGraphs()
}