import os
import cv2
import matplotlib.pyplot as plt
import numpy as np
import pandas as pd
import math
from PIL import Image
from skimage.feature import hog
from tqdm import tqdm
import random

#------------------------
def validation(zoz):
    test = []
    res = []
    index = 0
    index = round(random.randint(0,len(zoz)-1))
    res.append(zoz[index])
    for x in zoz:     
        if x != zoz[index] :
            test.append(x)
    return test, res

def euclidean_distance(a, b):
    x1 = a[0]; y1 = a[1]
    x2 = b[0]; y2 = b[1]
    
    return math.sqrt(((x2 - x1) * (x2 - x1)) + ((y2 - y1) * (y2 - y1)))

def detectFace(img):
    faces = face_detector.detectMultiScale(img, 1.3, 10)

    if len(faces) > 0:
        face = faces[0]
        face_x, face_y, face_w, face_h = face
        img = img[int(face_y):int(face_y+face_h), int(face_x):int(face_x+face_w)]
        img_gray = cv2.cvtColor(img, cv2.COLOR_BGR2GRAY)
        
        return img, img_gray
    else:
        img_gray = cv2.cvtColor(img, cv2.COLOR_BGR2GRAY)
        return img, img_gray

def alignFace(img_path):
    img = cv2.imread(img_path)

    img_raw = img.copy()

    img, gray_img = detectFace(img)
    
    eyes = eye_detector.detectMultiScale(gray_img, scaleFactor = 1.2, minNeighbors = 10, minSize = (5,5))
       
    if len(eyes) >= 2:
        
        base_eyes = eyes[:, 2]
        
        items = []
        for i in range(0, len(base_eyes)):
            item = (base_eyes[i], i)
            items.append(item)
        
        df = pd.DataFrame(items, columns = ["length", "idx"]).sort_values(by=['length'], ascending=False)
        
        eyes = eyes[df.idx.values[0:2]]
        
        eye_1 = eyes[0]; eye_2 = eyes[1]
        
        if eye_1[0] < eye_2[0]:
            left_eye = eye_1
            right_eye = eye_2
        else:
            left_eye = eye_2
            right_eye = eye_1
        
        
        left_eye_center = (int(left_eye[0] + (left_eye[2] / 2)), int(left_eye[1] + (left_eye[3] / 2)))
        left_eye_x = left_eye_center[0]; left_eye_y = left_eye_center[1]
        
        right_eye_center = (int(right_eye[0] + (right_eye[2]/2)), int(right_eye[1] + (right_eye[3]/2)))
        right_eye_x = right_eye_center[0]; right_eye_y = right_eye_center[1]
        
        
        cv2.circle(img, left_eye_center, 2, (255, 0, 0) , 2)
        cv2.circle(img, right_eye_center, 2, (255, 0, 0) , 2)
        
        if left_eye_y > right_eye_y:
            point_3rd = (right_eye_x, left_eye_y)
            direction = -1 
        else:
            point_3rd = (left_eye_x, right_eye_y)
            direction = 1 
        
        cv2.circle(img, point_3rd, 2, (255, 0, 0) , 2)
        
        cv2.line(img,right_eye_center, left_eye_center,(67,67,67),1)
        cv2.line(img,left_eye_center, point_3rd,(67,67,67),1)
        cv2.line(img,right_eye_center, point_3rd,(67,67,67),1)
        
        a = euclidean_distance(left_eye_center, point_3rd)
        b = euclidean_distance(right_eye_center, point_3rd)
        c = euclidean_distance(right_eye_center, left_eye_center)
        
        
        cos_a = (b*b + c*c - a*a)/(2*b*c)
        angle = np.arccos(cos_a)
        
        angle = (angle * 180) / math.pi
        
        if direction == -1:
            angle = 90 - angle
        
        
        new_img = Image.fromarray(img_raw)
        new_img = np.array(new_img.rotate(direction * angle))
    
    return new_img
    
#------------------------

face_detector = cv2.CascadeClassifier('haarcascade_frontalface_default.xml')
eye_detector = cv2.CascadeClassifier('haarcascade_eye.xml')

def hogPRVY(img):
    gx = cv2.Sobel(img, cv2.CV_32F, 1, 0)
    gy = cv2.Sobel(img, cv2.CV_32F, 0, 1)
    mag, ang = cv2.cartToPolar(gx, gy)
    bin_n = 16 
    bins = np.int32(bin_n*ang/(2*np.pi))

    bin_cells = bins[:10,:10], bins[10:,:10], bins[:10,10:], bins[10:,10:]
    mag_cells = mag[:10,:10], mag[10:,:10], mag[:10,10:], mag[10:,10:]
    hists = [np.bincount(b.ravel(), m.ravel(), bin_n) for b, m in zip(bin_cells, mag_cells)]
    hist = np.hstack(hists)
    return hist

def hogNVM(dat, check = False):
    hog_f = []
    ppc =8
    cb=4
    if check:
        fd = hog(dat , orientations=9 , pixels_per_cell=(ppc , ppc) , block_norm='L2' , cells_per_block=(cb,cb) , visualize=False, feature_vector = True)
        hog_f.append(fd)
    else:
            for image in tqdm(dat):
                fd = hog(image , orientations=9 , pixels_per_cell=(ppc , ppc) , block_norm='L2' , cells_per_block=(cb,cb) , visualize=False, feature_vector = True)
                hog_f.append(fd)
    return hog_f
#------------------------
test_set = []
res_set = []
all_r_set = ['rr1.jpg', 'rr2.jpg', 'rr3.jpg', 'rr4.jpg', 'rr5.jpg', 'rr6.jpg', 'rr7.jpg', 'rr8.jpg', 'rr9.jpg', 'rr10.jpg']
all_s_set = ['ss1.jpg', 'ss2.jpg', 'ss3.jpg', 'ss4.jpg', 'ss5.jpg', 'ss6.jpg', 'ss7.jpg', 'ss8.jpg', 'ss9.jpg', 'ss10.jpg']
all_a_set = ['as1.jpg', 'as2.jpg', 'as3.jpg', 'as4.jpg', 'as5.jpg', 'as6.jpg', 'as7.jpg', 'as8.jpg', 'as9.jpg', 'as10.jpg']
all_mato_set = ['mb1.jpg', 'mb2.jpg', 'mb3.jpg', 'mb4.jpg', 'mb5.jpg', 'mb6.jpg', 'mb7.jpg', 'mb8.jpg', 'mb9.jpg', 'mb10.jpg']
all_mama_set = ['ke1.jpg', 'ke2.jpg', 'ke3.jpg', 'ke4.jpg', 'ke5.jpg', 'ke6.jpg', 'ke7.jpg', 'ke8.jpg', 'ke9.jpg', 'ke10.jpg']
all_kubo_set = ['jk1.jpg', 'jk2.jpg', 'jk3.jpg', 'jk4.jpg', 'jk5.jpg', 'jk6.jpg', 'jk7.jpg', 'jk8.jpg', 'jk9.jpg']
all_koso_set = ['tk1.jpg', 'tk2.jpg', 'tk3.jpg', 'tk4.jpg', 'tk5.jpg', 'tk6.jpg', 'tk7.jpg', 'tk8.jpg', 'tk9.jpg', 'tk10.jpg', 'tk11.jpg', 'tk12.jpg']
all_ivana_set = ['ie1.jpg', 'ie2.jpg', 'ie3.jpg', 'ie4.jpg', 'ie5.jpg', 'ie6.jpg', 'ie7.jpg', 'ie8.jpg', 'ie9.jpg']
all_ja_set = ['fe1.jpg', 'fe2.jpg', 'fe3.jpg', 'fe4.jpg', 'fe5.jpg', 'fe6.jpg', 'fe7.jpg', 'fe8.jpg', 'fe9.jpg', 'fe10.jpg', 'fe11.jpg', 'fe12.jpg']
all_jea_set = ['jea1.jpg', 'jea2.jpg', 'jea3.jpg', 'jea4.jpg', 'jea5.jpg', 'jea6.jpg', 'jea7.jpg', 'jea8.jpg', 'jea9.jpg', 'jea10.jpg']
lab = []
index = 1
for i in range(10):
    test_set = []
    res_set = []
    lab = []
    index = 1
    for z in (all_mato_set, all_mama_set, all_kubo_set, all_koso_set,all_ivana_set, all_ja_set):   
        x, y = validation(z)
        test_set.extend(x)
        res_set.extend(y)
        lab.extend([index for i in range(len(z)-1)])
        index += 1
    labels = np.array(lab)
    print(res_set)
    height=128
    width=64
    data = []
    for filename in test_set:
            try:
                alignedFace = alignFace(filename)
                img, gray_img = detectFace(alignedFace)
                image= cv2.resize(img[:, :, ::-1] , (width,height))
                data.append(image)
            except UnboundLocalError:
                img, gray_img = detectFace(cv2.imread(filename))
                image= cv2.resize(img, (width,height))
                data.append(image)
    data_gray = [cv2.cvtColor(data[i] , cv2.COLOR_BGR2GRAY) for i in range(len(data))]
    hog_features = []
    hog_features = hogNVM(data_gray) 
    trainingData = np.matrix(hog_features, dtype=np.float32)
    svm = cv2.ml.SVM_create()
    svm.setType(cv2.ml.SVM_C_SVC)
    svm.setKernel(cv2.ml.SVM_LINEAR)
    svm.setTermCriteria((cv2.TERM_CRITERIA_MAX_ITER, 1000, 1e-6))
    svm.train(trainingData, cv2.ml.ROW_SAMPLE, labels)
    pom = []
    feat = []
    new_data = []
    for instance in res_set:
        try:
            alignedFace = alignFace(instance)       
            img, gray_img = detectFace(alignedFace)
            image= cv2.resize(img[:, :, ::-1] , (width,height))
            nev_data = image
            feat = hogNVM(cv2.cvtColor(nev_data , cv2.COLOR_BGR2GRAY),True)
            rData = np.matrix(feat, dtype=np.float32)
            response = svm.predict(rData)[1]
            print(response)
        except:
            img, gray_img = detectFace(cv2.imread(instance))
            image= cv2.resize(img, (width,height))
            nev_data = image
            feat = hogNVM(cv2.cvtColor(nev_data , cv2.COLOR_BGR2GRAY),True)
            rData = np.matrix(feat, dtype=np.float32)
            response = svm.predict(rData)[1]
            print(response)
