import os
import cv2
import matplotlib.pyplot as plt
import numpy as np
import pandas as pd
import math
from PIL import Image
from skimage.feature import hog
from tqdm import tqdm
import random
import time

class Face_recognition:
    def __init__(self):
        self.faceCascade = cv2.CascadeClassifier("haarcascade_frontalface_default.xml")
        self.eye_detector = cv2.CascadeClassifier('haarcascade_eye.xml')
        
        self.all_r_set = ['rr1.jpg', 'rr2.jpg', 'rr3.jpg', 'rr4.jpg', 'rr5.jpg', 'rr6.jpg', 'rr7.jpg', 'rr8.jpg', 'rr9.jpg', 'rr10.jpg']
        self.all_s_set = ['ss1.jpg', 'ss2.jpg', 'ss3.jpg', 'ss4.jpg', 'ss5.jpg', 'ss6.jpg', 'ss7.jpg', 'ss8.jpg', 'ss9.jpg', 'ss10.jpg']
        self.all_a_set = ['as1.jpg', 'as2.jpg', 'as3.jpg', 'as4.jpg', 'as5.jpg', 'as6.jpg', 'as7.jpg', 'as8.jpg', 'as9.jpg', 'as10.jpg']
        self.all_mb_set = ['mb1.jpg', 'mb2.jpg', 'mb3.jpg', 'mb4.jpg', 'mb5.jpg', 'mb6.jpg', 'mb7.jpg', 'mb8.jpg', 'mb9.jpg', 'mb10.jpg']
        self.all_ke_set = ['ke1.jpg', 'ke2.jpg', 'ke3.jpg', 'ke4.jpg', 'ke5.jpg', 'ke6.jpg', 'ke7.jpg', 'ke8.jpg', 'ke9.jpg', 'ke10.jpg']
        self.all_jk_set = ['jk1.jpg', 'jk2.jpg', 'jk3.jpg', 'jk4.jpg', 'jk5.jpg', 'jk6.jpg', 'jk7.jpg', 'jk8.jpg', 'jk9.jpg']
        self.all_tk_set = ['tk1.jpg', 'tk2.jpg', 'tk3.jpg', 'tk4.jpg', 'tk5.jpg', 'tk6.jpg', 'tk7.jpg', 'tk8.jpg', 'tk9.jpg', 'tk10.jpg', 'tk11.jpg', 'tk12.jpg']
        self.all_ie_set = ['ie1.jpg', 'ie2.jpg', 'ie3.jpg', 'ie4.jpg', 'ie5.jpg', 'ie6.jpg', 'ie7.jpg', 'ie8.jpg', 'ie9.jpg']
        self.all_fe_set = ['fe1.jpg', 'fe2.jpg', 'fe3.jpg', 'fe4.jpg', 'fe5.jpg', 'fe6.jpg', 'fe7.jpg', 'fe8.jpg', 'fe9.jpg', 'fe10.jpg', 'fe11.jpg', 'fe12.jpg']
        self.all_jea_set = ['jea1.jpg', 'jea2.jpg', 'jea3.jpg', 'jea4.jpg', 'jea5.jpg', 'jea6.jpg', 'jea7.jpg', 'jea8.jpg', 'jea9.jpg', 'jea10.jpg']
        self.recognized = False
        self.train_svm()
        self.detect()

    def train_svm(self):
        index = 1
        test_set = []
        lab = []
        for z in (self.all_r_set,self.all_s_set,self.all_a_set,self.all_mb_set, self.all_ke_set, self.all_jk_set, self.all_tk_set,self.all_ie_set, self.all_fe_set, self.all_jea_set):
            test_set.extend(z)
            lab.extend([index for i in range(len(z))])
            index += 1
        labels = np.array(lab)
        height=128
        width=64
        data = []
        for filename in test_set:
                try:
                    alignedFace = self.align_face(filename)
                    img, gray_img = self.detect_face(alignedFace)
                    image= cv2.resize(img[:, :, ::-1] , (width,height))
                    data.append(image)
                except UnboundLocalError:
                    img, gray_img = self.detect_face(cv2.imread(filename))
                    image= cv2.resize(img, (width,height))
                    data.append(image)

        data_gray = [cv2.cvtColor(data[i] , cv2.COLOR_BGR2GRAY) for i in range(len(data))]
        hog_f = []
        hog_f = self.hog_features(data_gray, 9) 

        trainingData = np.matrix(hog_f, dtype=np.float32)

        self.svm = cv2.ml.SVM_create()
        self.svm.setType(cv2.ml.SVM_C_SVC)
        self.svm.setKernel(cv2.ml.SVM_LINEAR)
        self.svm.setTermCriteria((cv2.TERM_CRITERIA_MAX_ITER, 1000, 1e-6))
        self.svm.train(trainingData, cv2.ml.ROW_SAMPLE, labels)
    def euclidean_distance(self,a, b):
            x1 = a[0]; y1 = a[1]
            x2 = b[0]; y2 = b[1]	
            return math.sqrt(((x2 - x1) * (x2 - x1)) + ((y2 - y1) * (y2 - y1)))

    def find_eyes(self,img_path):
        obrz = cv2.imread(img_path)
        sivy = cv2.cvtColor(obrz, cv2.COLOR_BGR2GRAY)
        eyes = []
        najdi_tvare = self.faceCascade.detectMultiScale(sivy, 1.3, 5)

        for (stlpec,riadok,width,height) in najdi_tvare:
            cv2.rectangle(obrz,(stlpec,riadok),(stlpec+width,riadok+height),(255,0,0),2)
            roi_gray = sivy[riadok:riadok+height, stlpec:stlpec+width]
            roi_color = obrz[riadok:riadok+height, stlpec:stlpec+width]
            eyes = self.eye_detector.detectMultiScale(roi_gray)
        return len(eyes)

    def validation(self,zoz):
        test = []
        res = []
        index = 0
        index = round(random.randint(0,len(zoz)-1))
        res.append(zoz[index])
        for x in zoz:     
            if x != zoz[index] :
                test.append(x)
        return test, res

    def align_face(self,img_path):
        img = cv2.imread(img_path)

        img_raw = img.copy()

        img, gray_img = self.detect_face(img)
        
        eyes = self.eye_detector.detectMultiScale(gray_img, scaleFactor = 1.2, minNeighbors = 10, minSize = (5,5))
        
        if len(eyes) >= 2:  
            base_eyes = eyes[:, 2]
            items = []
            for i in range(0, len(base_eyes)):
                item = (base_eyes[i], i)
                items.append(item)
            
            df = pd.DataFrame(items, columns = ["length", "idx"]).sort_values(by=['length'], ascending=False)
            
            eyes = eyes[df.idx.values[0:2]]            
            eye_1 = eyes[0]; eye_2 = eyes[1]
            
            if eye_1[0] < eye_2[0]:
                left_eye = eye_1
                right_eye = eye_2
            else:
                left_eye = eye_2
                right_eye = eye_1
            left_eye_center = (int(left_eye[0] + (left_eye[2] / 2)), int(left_eye[1] + (left_eye[3] / 2)))
            left_eye_x = left_eye_center[0]; left_eye_y = left_eye_center[1]
            
            right_eye_center = (int(right_eye[0] + (right_eye[2]/2)), int(right_eye[1] + (right_eye[3]/2)))
            right_eye_x = right_eye_center[0]; right_eye_y = right_eye_center[1]
            
            
            cv2.circle(img, left_eye_center, 2, (255, 0, 0) , 2)
            cv2.circle(img, right_eye_center, 2, (255, 0, 0) , 2)
            
            if left_eye_y > right_eye_y:
                point_3rd = (right_eye_x, left_eye_y)
                direction = -1 
            else:
                point_3rd = (left_eye_x, right_eye_y)
                direction = 1 
            
            
            cv2.circle(img, point_3rd, 2, (255, 0, 0) , 2)
            
            cv2.line(img,right_eye_center, left_eye_center,(67,67,67),1)
            cv2.line(img,left_eye_center, point_3rd,(67,67,67),1)
            cv2.line(img,right_eye_center, point_3rd,(67,67,67),1)
            
            a = self.euclidean_distance(left_eye_center, point_3rd)
            b = self.euclidean_distance(right_eye_center, point_3rd)
            c = self.euclidean_distance(right_eye_center, left_eye_center)
   
            cos_a = (b*b + c*c - a*a)/(2*b*c)

            angle = np.arccos(cos_a)
            
            angle = (angle * 180) / math.pi
            
            if direction == -1:
                angle = 90 - angle
            
            new_img = Image.fromarray(img_raw)
            new_img = np.array(new_img.rotate(direction * angle))
        
        return new_img

    def hog_features(self,dat, check):
        hog_f = []
        ppc =8
        cb=4
        if check == 1:
            fd = hog(dat , orientations=9 , pixels_per_cell=(ppc , ppc) , block_norm='L2' , cells_per_block=(cb,cb) , visualize=False, feature_vector = True)
            hog_f.append(fd)
        else:
                for image in tqdm(dat):
                    fd = hog(image , orientations=9 , pixels_per_cell=(ppc , ppc) , block_norm='L2' , cells_per_block=(cb,cb) , visualize=False, feature_vector = True)
                    hog_f.append(fd)
        return hog_f

    def is_human(self,image):
        min_YCrCb = np.array([0,133,77],np.uint8)
        max_YCrCb = np.array([235,173,127],np.uint8)
        imageYCrCb = cv2.cvtColor(image,cv2.COLOR_BGR2YCR_CB)
        skinRegionYCrCb = cv2.inRange(imageYCrCb,min_YCrCb,max_YCrCb)
        skinYCrCb = cv2.bitwise_and(image, image, mask = skinRegionYCrCb)
        return (np.count_nonzero(np.hstack([image,skinYCrCb])) > 10000)

    def recognize(self,image):
        img, gray_img = self.detect_face(image)
        image= cv2.resize(img[:, :, ::-1] , (64,128))
        feat = self.hog_features(cv2.cvtColor(image , cv2.COLOR_BGR2GRAY), 1)
        rData = np.matrix(feat, dtype=np.float32)
        response = self.svm.predict(rData)[1]
        return self.name(response)

    def name(self, argument):
        if argument == [[1.]]:
            return "Ryan Reynolds"
        if argument == [[2.]]:
            return "Sylvester Stallone"
        if argument == [[3.]]:
            return "Arnold Schwarzenegger"
        if argument == [[4.]]:
            return "Martin Bohumel"
        if argument == [[5.]]:
            return "Kvetoslava Eliašová"
        if argument == [[6.]]:
            return "Jakub Koka"
        if argument == [[7.]]:
            return "Tomáš Kosec"
        if argument == [[8.]]:
            return "Ivana Eliašová"
        if argument == [[9.]]:
            return "Filip Eliaš"
        return ""
            
    def detect_face(self,img):
        
        starting_n = 10
        faces = []
        while len(faces) == 0 and starting_n > 0:
            faces = self.faceCascade.detectMultiScale(img, 1.3, starting_n)
            starting_n -= 1
        if len(faces) > 0:
            face = faces[0]
            face_x, face_y, face_w, face_h = face
            img = img[int(face_y):int(face_y+face_h), int(face_x):int(face_x+face_w)]
            img_gray = cv2.cvtColor(img, cv2.COLOR_BGR2GRAY) 
            return img, img_gray
        else:
            img_gray = cv2.cvtColor(img, cv2.COLOR_BGR2GRAY)
            return img, img_gray

    def detect(self):
        cap = cv2.VideoCapture(0)
        if cap.isOpened() == 0:
            exit(-1)

        fgbg = cv2.bgsegm.createBackgroundSubtractorMOG()
        cap.set(cv2.CAP_PROP_FRAME_WIDTH, 2560)
        cap.set(cv2.CAP_PROP_FRAME_HEIGHT, 1080)

        face_images_simple = []
        face_images_aligned = []
        human = False
        start = 0
        while True :
            retval, frame = cap.read()
            
            gray = cv2.cvtColor(frame, cv2.COLOR_BGR2GRAY)

            fgmask = fgbg.apply(frame)

            count = np.count_nonzero(fgmask)

            faces = self.faceCascade.detectMultiScale(
                        gray,
                        scaleFactor=1.1,
                        minNeighbors=10,
                        minSize=(30, 30)
                )

            if(count > 15000):
                if(human is False):
                    human = self.is_human(frame)
                    if start == 0 and human:
                        start = time.time()
                        print(start)
            if (len(faces) != 0 and human and len(face_images_aligned) == 0):
                print('tvar')
                cisl = random.randint(1,10000)
                pom = "frame%d.jpg" % cisl
                cv2.imwrite(pom,  frame)
                face_images_simple.append(pom)
                if len(face_images_simple) != 0:
                    print('reco')
                    for i in face_images_simple:
                        print(i)
                        if self.find_eyes(i) > 1:
                            print('oci')
                            try:
                                face_images_aligned.append(self.align_face(i))
                                break
                            except UnboundLocalError:
                                continue
                        elif start != 0 and time.time() - start > 15 and self.recognized == False and len(face_images_simple) != 0 and len(face_images_aligned) == 0:
                            print(self.recognize(cv2.imread(face_images_simple[0])))
                            self.recognized = True
                            break

            if start != 0 and time.time() - start > 15 and self.recognized == False and len(face_images_simple) != 0 and len(face_images_aligned) == 0:
                print(self.recognize(cv2.imread(face_images_simple[0])))
                self.recognized = True 

            if len(face_images_aligned) != 0:
                for i in face_images_aligned:
                    print(self.recognize(i))
                    self.recognized = True
                    
            if human and len(face_images_simple) == 0 and start != 0 and time.time() - start > 30 and self.recognized == False:
                print("Detegujem neznámu osobu")
                start = 0
                
            if self.recognized:
                for i in face_images_simple:
                    os.remove(i)
                self.recognized = False
                face_images_aligned = []
                face_images_simple = []
                start = 0
                human = False
        
            for (x, y, w, h) in faces:
                    cv2.rectangle(frame, (x, y), (x+w, y+h), (0, 255, 0), 2)
            left_right_image = np.split(frame, 2, axis=1)
         
            k = cv2.waitKey(30) & 0xff
            if k == 27:
                break
            cv2.imshow("frame", frame)
            cv2.imshow("right", left_right_image[0])
            cv2.imshow("left", left_right_image[1])
            if cv2.waitKey(30) >= 0 :
                break
        exit(0)
Face_recognition()
