<?php

// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * @package   mod_survey
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

// STANDARD FUNCTIONS ////////////////////////////////////////////////////////
/**
 * Given an object containing all the necessary data,
 * (defined by the form in mod_form.php) this function
 * will create a new instance and return the id number
 * of the new instance.
 *
 * @global object
 * @param object $peerbadges
 * @return int|bool
 */
function gamification_add_instance($gamification) {
    global $DB;

    $gamification->timecreated  = time();
    $gamification->timemodified = $gamification->timecreated;

    if(!$pbid = $DB->insert_record("gamification", $gamification, true)){
				return false;
		}

		/*foreach($peerbadges->badgeids as $badge){
				if($badge > 0){
						$object = new stdClass();
						$object->badgeid = $badge;
						$object->peerbadgesid = $pbid;
						if(!($DB->insert_record("peerbadges_badgemodule", $object))){
								return false;
						}
				}
		}*/

		return 1;
}
?>
