<?php
if (!defined('MOODLE_INTERNAL')) {
    die('Direct access to this script is forbidden.');    ///  It must be included from a Moodle page
}

require_once ($CFG->dirroot.'/course/moodleform_mod.php');

class mod_gamification_mod_form extends moodleform_mod {

    function definition() {
        global $CFG, $DB, $COURSE;

        $mform =& $this->_form;

        //$strrequired = get_string('required');

//-------------------------------------------------------------------------------
        $mform->addElement('header', 'general', get_string('general', 'form'));

        $mform->addElement('text', 'name', get_string('name'), array('size'=>'64'));
        if (!empty($CFG->formatstringstriptags)) {
            $mform->setType('name', PARAM_TEXT);
        } else {
            $mform->setType('name', PARAM_CLEANHTML);
        }

        $mform->addElement('text', 'width', get_string('width', "gamification"), array('size'=>'6'));
        $mform->addElement('text', 'height', get_string('height', "gamification"), array('size'=>'6'));

        $options = array(
            '2' => 2,
            '3' => 3,
            '4' => 4,
            '5' => 5,
            '6' => 6,
            '7' => 7,
            '8' => 8,
            '9' => 9
        );
        $select = $mform->addElement('select', 'num_of_questions', get_string('numofquestions', "gamification"), $options);
        $select->setSelected('2');

        $mform->addElement('filepicker', 'picture', get_string('picture', "gamification"), null, array('maxbytes' => $maxbytes, 'accepted_types' => '*'));


        //RULES
        $mform->addRule('name', null, 'required', null, 'client');
        $mform->addRule('picture', null, 'required', null, 'client');

        $this->standard_intro_elements(get_string('customintro', 'gamification'));

        $this->standard_coursemodule_elements();

//-------------------------------------------------------------------------------
        // buttons
        $this->add_action_buttons();
    }

}
