<?php
// This file is part of Moodle - http://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <http://www.gnu.org/licenses/>.

/**
 * This file is responsible for displaying the survey
 *
 * @package   mod_survey
 * @copyright 1999 onwards Martin Dougiamas  {@link http://moodle.com}
 * @license   http://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

require_once("../../config.php");
require_once("lib.php");
require_once("classes/table.php");

$id = required_param('id', PARAM_INT);    // Course Module ID.

if (! $cm = get_coursemodule_from_id('gamification', $id)) {
		print_error('invalidcoursemodule');
}

if (! $course = $DB->get_record("course", array("id" => $cm->course))) {
		print_error('coursemisconf');
}

$PAGE->set_url('/mod/gamification/view.php', array('id' => $id));
require_login($course, false, $cm);
$context = context_module::instance($cm->id);

require_capability('mod/gamification:participate', $context);

//TODO should we handle deleted instances here? it seems to be reasonable since you can pass course module id just by stupid GET
if (! $pb = $DB->get_record("gamification", array("id" => $cm->instance))) {
		print_error('invalidpbid', 'gamification');
}

//TODO change stuff so intro is made automatically - who they are assessing
$trimmedintro = trim($pb->intro);
//TODO add something about the fact that they have to check at least one checkbox

// Update 'viewed' state if required by completion system.
require_once($CFG->libdir . '/completionlib.php');
$completion = new completion_info($course);
$completion->set_module_viewed($cm);

$PAGE->set_title($pb->name);
$PAGE->set_heading($course->fullname);
echo $OUTPUT->header();
echo $OUTPUT->heading($pb->name);

$table = new Table(1, $pb->num_of_questions, $pb->width, $pb->height);
$table->addCorrectAns(1);

echo $pb->height;
//echo "<div id='mainDiv' style='height:".$pb->height."px; width:".$pb->width."'>";
echo "<div id='mainDiv'>";
$table->showPic();
$table->printCompleteTable();
echo "</div>";

echo $OUTPUT->footer();

?>
