<?php

  class Table{


    private $pic_id = -1;
    private $num_of_questions = 0;
    private $correct_ans = array();
    private $width_of_pic = 0;
    private $height_of_pic = 0;
    private $show_pic = false;


    function __construct( $id, $questions, $width, $height){
      $this->pic_id = $id;
      $this->num_of_questions = $questions;
      $this->width_of_pic = $width;
      $this->height_of_pic = $height;

      for ( $i = 0; $i < $questions; $i++ ){
        array_push($this->correct_ans, $i);
      }
    }

    function printCompleteTable(){
      $counter = 1;

      $questions = $this->num_of_questions/2;
      if ( $this->num_of_questions % 2 == 0 ){
        $counter = $this->printPartOfTable($counter, $questions, 0);
        $this->printPartOfTable($counter, $questions, $this->height_of_pic/2);
      }
      else {
        $counter = $this->printPartOfTable($counter, $questions, 0);
        $this->printPartOfTable($counter, $questions-1, $this->height_of_pic/2);
      }

    }

    function printPartOfTable($counter, $num_of_questions, $top){
      $black = "bgcolor='#000'";


      $styleTable = "style='top:".$top."px; border-collapse:collapse; width:100%; height:". $this->height_of_pic/2 ."px;'";

      $top = 1 / round($this->num_of_questions/2);
      if ( $this->num_of_questions % 2 == 0 ) {
        $bottom = 1 / round($this->num_of_questions/2);
      }
      else $bottom = 1 / (round($this->num_of_questions/2) - 1);

      $none = "class='noHover' style='width:". $bottom ."'";

      echo "<table id='tableMoja' " . $styleTable . ">";
      echo "<tr>";
      for ($k=0; $k < $num_of_questions; $k++){
        if ( !in_array($counter-1, $this->correct_ans) || $this->show_pic ) {
          echo "<td " . $none . " id='" . $counter . "'>1</td>";
        }
        else echo "<td " . $black . " id='" . $counter . "'> <a href='#'>" . $counter . "</a> </td>";
        $counter++;
      }

      echo "</tr>";
      echo "</table>";
      return $counter;
    }

    function addCorrectAns( $id ){
      unset($this->correct_ans[array_search($id-1, $this->correct_ans)]);
      //$this->printCompleteTable();
    }

    function finalAnswer(){
      $this->correct_ans = array();
      $this->show_pic = true;
      //$this->printCompleteTable();
    }

    function showPic(){
      $top_ans = $this->makeArrOfTopAns();
      $bottom_ans = $this->makeArrOfBottomAns();

      $image = imagecreatefromstring(file_get_contents('1.jpg'));
      $black = imagecolorallocate($image, 0, 0, 0);

      $top = 1 / round($this->num_of_questions/2);
      if ( $this->num_of_questions % 2 == 0 ) {
        $bottom = 1 / round($this->num_of_questions/2);
      }
      else $bottom = 1 / (round($this->num_of_questions/2) - 1);

      $image = $this->recolorPicture($image, $top_ans, $top);
      $image = $this->recolorPicture($image, $bottom_ans, $bottom, true);

      ob_start();
      imagejpeg($image, NULL, 100);
      $rawImageBytes = ob_get_clean();

      echo "<img id='pic' src='data:image/jpeg;base64," . base64_encode( $rawImageBytes ) . "' height='600' width='800' />";
    }

    function makeArrOfTopAns(){
      $top_ans = array();
      $i = 0;

      while ( $i < $this->num_of_questions/2 ){
        if( in_array($i, $this->correct_ans) ) array_push($top_ans, $i);
        $i++;
      }

      return $top_ans;
    }

    function makeArrOfBottomAns(){
      $bottom_ans = array();
      $i = round($this->num_of_questions/2);

      while ( $i < $this->num_of_questions ){
        if( in_array($i, $this->correct_ans) ) {
          array_push($bottom_ans, $i-round($this->num_of_questions/2));
        }
        $i++;
      }

      return $bottom_ans;
    }

    function recolorPicture($image, $arr, $ratio, $bot = false){
      $w = imagesx($image);
      $h = imagesy($image);
      if( !$bot ){
        foreach ( $arr as $a ){
          for($y = 0; $y < $h/2; $y++) {
            for($x = $w * $ratio * $a; $x < $w * $ratio * ($a+1); $x++) {
              imagesetpixel($image, $x, $y, $black);
            }
          }
        }
      }
      else{
        foreach ( $arr as $a ){
          for($y = $h/2; $y < $h; $y++) {
            for($x = $w * $ratio * $a; $x < $w * $ratio * ($a+1); $x++) {
              imagesetpixel($image, $x, $y, $black);
            }
          }
        }
      }
      return $image;
    }

  }

?>
