// Fill out your copyright notice in the Description page of Project Settings.

using System.IO;
using UnrealBuildTool;

public class BachelorPrototype : ModuleRules
{

    private string ModulePath
    {
        get { return ModuleDirectory; }
    }

    private string SkeletexPath
    {
        get { return Path.GetFullPath(Path.Combine(ModulePath, "../../Skeletex/")); }
    }

    public bool LoadLibraries()
    {
        PublicIncludePaths.Add(Path.Combine(SkeletexPath, "include"));
        PublicDefinitions.Add(string.Format("WITH_PCL_BINDING={0}", true ? 1 : 0));
        PublicAdditionalLibraries.Add(Path.Combine(SkeletexPath, "lib", "Release", "COGS.lib"));
        PublicAdditionalLibraries.Add(Path.Combine(SkeletexPath, "lib", "Release", "GEOM.lib"));
        return true;
    }

    public BachelorPrototype(ReadOnlyTargetRules Target) : base(Target)
	{
        
        PCHUsage = PCHUsageMode.UseExplicitOrSharedPCHs;
	
		PublicDependencyModuleNames.AddRange(new string[] { "Core", "CoreUObject", "Engine", "InputCore", "UMG", "ProceduralMeshComponent", "HeadMountedDisplay" });

		// Uncomment if you are using Slate UI
		PrivateDependencyModuleNames.AddRange(new string[] { "ApplicationCore", "Slate", "SlateCore" });

        // Uncomment if you are using online features
        // PrivateDependencyModuleNames.Add("OnlineSubsystem");

        // To include OnlineSubsystemSteam, add it to the plugins section in your uproject file with the Enabled attribute set to true

        LoadLibraries();

    }


}
