// @ Luk Gajdoech 2019

#pragma once

#include "CoreMinimal.h"
#include "UObject/NoExportTypes.h"
#include "PointCloudLoader.generated.h"

/**
 * \brief Manages the import and export of cloud data files in XYZ format.
 */
UCLASS()
class BACHELORPROTOTYPE_API UPointCloudLoader : public UObject
{
	GENERATED_BODY()

public:

  /**
   * Gets the file extension from the given file name.
   * @param fileName Full name of the file with dot followed by an extension.
   */
	static FString GetExtension(FString fileName);

  /**
   * Saves the given scan into the Content folder, adding EXPORT_ to its original name
   * @param scan Pointer to the UPointCloudScan which will be saved.
   */
	static void Save(class UPointCloudScan* scan);

  /**
   * Returns the point cloud data from the given file.
   * @param fileName Name of the file inside of the Content/XYZFiles folder.
   * @param mode Pointer to the current ABachelorMode, checks if the file has not been already pre-loaded.
   */
	static class UPointCloud* Load(FString fileName, class ABachelorMode* mode);

  /**
   * Pre-load all XYZ files from the Content/XYZFiles folder and saves them into the array of current mode.
   * @param mode Pointer to the current instance of ABachelorMode.
   */
	static void Preload(class ABachelorMode* mode);

  /**
   * Returns array of file names inside of the Content/XYZFiles folder
   * @param bDebugPrint Whether the file names should be printed to the console.
   */
	static TArray<FString> ListFiles(bool bDebugPrint = false);

private: 

	static class UPointCloud* LoadFromFile(FString fileName, class ABachelorMode* gameMode);

	static class UPointCloud* LoadFromMemory(FString name, class ABachelorMode* gameMode);

	static void DefaultSettings(class UPointCloud* pointCloud);
};
