// @ Luk Gajdoech 2019

#pragma once

#include "CoreMinimal.h"
#include "GameFramework/GameModeBase.h"
#include "BachelorMode.generated.h"

/**
 * \brief Mode of the tool.
 */
UCLASS()
class BACHELORPROTOTYPE_API ABachelorMode : public AGameModeBase
{
	GENERATED_BODY()

public:

  /**
   * Constructor, sets the the AUserController, AUser and setups GUI.
   */
	ABachelorMode();

  /**
   * Called internally at the start-up, initializes the GUI.
   */
	virtual void BeginPlay() override;

  /**
   * Change the root widget of the GUI menu.
   * @param newWidgetClass Subclass of UUserWidget to be used as a new GUI, no GUI is rendered if nullptr.
   */
	UFUNCTION(BluePrintCallable, Category = "Mode Functions")
	void ChangeMenuWidget(TSubclassOf<UUserWidget> newWidgetClass);

  /**
   * Toggles the virtual reality mode.
   */
	UFUNCTION(BluePrintCallable, Category = "Mode Functions")
	bool ToggleVRMode();

  /**
   * Whether the tool is in the virtual reality mode.
   */
  bool IsVRMode() { return bVRMode; }

  /**
   * Gets the current GUI menu widget.
   */
  UUserWidget *GetCurrentWidget() { return currentWidget;  }

  /**
   * Array of point cloud data preloaded at the start-up.
   */
	UPROPERTY(EditAnywhere, BluePrintReadWrite, Category = "Mode Properties")
	TArray<class UPointCloud*> preloadedPointClouds;

private:

  bool bVRMode = false;

  TSubclassOf<UUserWidget> startingWidgetClass;

  UPROPERTY()
  UUserWidget *currentWidget;
};
