// @ Luk Gajdoech 2019

#include "Settings.h"
#include "Engine.h"
#include "GameFramework/GameUserSettings.h"


void USettings::ConsoleSettings() 
{
	GEngine->Exec(GetWorld(), TEXT("stat fps"));
}

void USettings::LowSettings() 
{
	UGameUserSettings* settings = GetUEngineSettings();
	if (settings != nullptr) 
	{
		settings->ScalabilityQuality.ViewDistanceQuality = 0;
		settings->ScalabilityQuality.AntiAliasingQuality = 0; 
		settings->ScalabilityQuality.PostProcessQuality = 0;
		settings->ScalabilityQuality.ShadowQuality = 3;
		settings->ScalabilityQuality.TextureQuality = 1;
		settings->ScalabilityQuality.EffectsQuality = 0;
		settings->ScalabilityQuality.FoliageQuality = 0;
		settings->ApplySettings(false);
		settings->SaveSettings();
	}
}

void USettings::HighSettings() 
{
	UGameUserSettings* settings = GetUEngineSettings();
	if (settings != nullptr) 
	{
		settings->ScalabilityQuality.ViewDistanceQuality = 3;
		settings->ScalabilityQuality.AntiAliasingQuality = 3;
		settings->ScalabilityQuality.PostProcessQuality = 3;
		settings->ScalabilityQuality.ShadowQuality = 3;
		settings->ScalabilityQuality.TextureQuality = 3;
		settings->ScalabilityQuality.EffectsQuality = 3;
		settings->ScalabilityQuality.FoliageQuality = 3;
		settings->ApplySettings(false);
		settings->SaveSettings();
	}
}

UGameUserSettings* USettings::GetUEngineSettings()
{
	if (GEngine != nullptr)
	{
		return GEngine->GameUserSettings;
	}
	return nullptr;
}
