// @ Luk Gajdoech 2019

#pragma once

#include "CoreMinimal.h"
#include "UObject/NoExportTypes.h"
#include "Settings.generated.h"

/**
 * \brief Graphics settings of the program.
 */
UCLASS()
class BACHELORPROTOTYPE_API USettings : public UObject
{
	GENERATED_BODY()
	
public:
	
  /**
   * Activate the defined console settings, like showing the performance info bar. 
   */
	UFUNCTION(BlueprintCallable, Category = "SettingsFunction")
	void ConsoleSettings();

  /**
   * Activate Low graphics settings.
   * - disabled post processing effects (bloom, anti-aliasing etc.)
   * - lower view distance
   * - disabled reflections
   */
	UFUNCTION(BlueprintCallable, Category = "SettingsFunction")
	void LowSettings();

  /**
 * Activate High graphics settings.
 * - all post processing effects enabled (bloom, anti-aliasing etc.)
 * - high view distance
 * - reflections enabled
 */
	UFUNCTION(BlueprintCallable, Category = "SettingsFunction")
	void HighSettings();

private:
  class UGameUserSettings* GetUEngineSettings();
};
