// @ Luk Gajdoech 2019

#include "BachelorMode.h"

#include "Engine.h"
#include "ConstructorHelpers.h"
#include "Blueprint/UserWidget.h"

#include "Control/User.h"
#include "Control/UserController.h"
#include "Interface/UserHUD.h"

ABachelorMode::ABachelorMode() 
{
	ConstructorHelpers::FClassFinder<UUserWidget> widgetObject(TEXT("/Game/Blueprints/UI_BP"));
	startingWidgetClass = widgetObject.Class;
	PlayerControllerClass = AUserController::StaticClass();
	DefaultPawnClass = AUser::StaticClass();
	//HUDClass = AUserHUD::StaticClass();
}

void ABachelorMode::BeginPlay()
{
	Super::BeginPlay();
	ChangeMenuWidget(startingWidgetClass);
}

void ABachelorMode::ChangeMenuWidget(TSubclassOf<UUserWidget> newWidgetClass)
{
	if (currentWidget != nullptr)
	{
		currentWidget->RemoveFromViewport();
		currentWidget = nullptr;
	}
	if (newWidgetClass != nullptr)
	{
		currentWidget = CreateWidget<UUserWidget>(GetWorld(), newWidgetClass);
		if (currentWidget != nullptr)
		{
			currentWidget->AddToViewport();
		}
	}
}

bool ABachelorMode::ToggleVRMode()
{
	bVRMode = !bVRMode;
	if (bVRMode) 
	{
		GetWorld()->GetFirstPlayerController()->bShowMouseCursor = false;
		ChangeMenuWidget(nullptr);
		GEngine->Exec(GetWorld(), TEXT("vr.PixelDensity 1.7"));
	}
	else 
	{
		GetWorld()->GetFirstPlayerController()->bShowMouseCursor = true;
		ChangeMenuWidget(startingWidgetClass);
	}
	return bVRMode;
}




