// Fill out your copyright notice in the Description page of Project Settings.

#include "BachelorPrototypeGameModeBase.h"
#include "Blueprint/UserWidget.h"
#include "EngineUtils.h"
#include "User.h"
#include "UserController.h"
#include "ConstructorHelpers.h"
//#include "GameFramework/PlayerController.h"

ABachelorPrototypeGameModeBase::ABachelorPrototypeGameModeBase() {
	
	static ConstructorHelpers::FClassFinder<UUserWidget> widget_ob(TEXT("/Game/Blueprints/UI_BP"));
	
	starting_widget_class = widget_ob.Class;
	
	DefaultPawnClass = AUser::StaticClass();
	PlayerControllerClass = AUserController::StaticClass();

}

void ABachelorPrototypeGameModeBase::BeginPlay()
{
	Super::BeginPlay();
	ChangeMenuWidget(starting_widget_class);

}

void ABachelorPrototypeGameModeBase::ChangeMenuWidget(TSubclassOf<UUserWidget> new_widget_class)
{
	if (current_widget != nullptr)
	{
		current_widget->RemoveFromViewport();
		current_widget = nullptr;
	}
	if (new_widget_class != nullptr)
	{
		current_widget = CreateWidget<UUserWidget>(GetWorld(), new_widget_class);
		if (current_widget != nullptr)
		{
			current_widget->AddToViewport();
		}
	}
}


