// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "GameFramework/GameModeBase.h"
#include "BachelorPrototypeGameModeBase.generated.h"

/**
 * 
 */
UCLASS()
class BACHELORPROTOTYPE_API ABachelorPrototypeGameModeBase : public AGameModeBase
{
	GENERATED_BODY()

public:
	/** Remove the current menu widget and create a new one from the specified class, if provided. */
	void ChangeMenuWidget(TSubclassOf<UUserWidget> new_widget_class);

protected:
	ABachelorPrototypeGameModeBase();

	/** Called when the game starts. */
	virtual void BeginPlay() override;

	/** The widget class we will use as our menu when the game starts. */
	TSubclassOf<UUserWidget> starting_widget_class;

	/** The widget instance that we are using as our menu. */
	UUserWidget* current_widget;
	
};
