// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "GameFramework/Actor.h"
#include "SphereSpawner.generated.h"

UCLASS()
class BACHELORPROTOTYPE_API ASphereSpawner : public AActor
{
	GENERATED_BODY()
	
public:	
	// Sets default values for this actor's properties
	ASphereSpawner();

	// Called every frame
	virtual void Tick(float DeltaTime) override;

	UPROPERTY(EditAnywhere)
	UStaticMeshComponent* mesh;

	void SpawnSpheres();
	bool LoadCoords(FString fileName);

protected:
	// Called when the game starts or when spawned
	virtual void BeginPlay() override;

private:
	FVector* coords_ = new FVector[1]{ FVector(0, 0, 0) };
	int coords_count_ = 1;
};
