// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "GameFramework/Pawn.h"
#include "User.generated.h"

UCLASS()
class BACHELORPROTOTYPE_API AUser : public APawn
{
	GENERATED_BODY()

public:
	// Sets default values for this pawn's properties
	AUser();

protected:
	// Called when the game starts or when spawned
	virtual void BeginPlay() override;

public:
	// Called every frame
	virtual void Tick(float DeltaTime) override;

	// Called to bind functionality to input
	virtual void SetupPlayerInputComponent(class UInputComponent* PlayerInputComponent) override;

	void MoveForward() { current_velocity_.X = 1; };
	void MoveBackward() { current_velocity_.X = -1; };
	void MoveRight() { current_velocity_.Y = 1; };
	void MoveLeft() { current_velocity_.Y = -1; };
	void StopMovement() { current_velocity_.X = current_velocity_.Y = 0; };
	void YawLeft() { current_rotation_ = FRotator(0, -0.5, 0); };
	void YawRight() { current_rotation_ = FRotator(0, 0.5, 0); };
	void PitchUp() { current_rotation_ = FRotator(0.3, 0, 0); };
	void PitchDown() { current_rotation_ = FRotator(-0.3, 0, 0); };
	void StopRotation() { current_rotation_ = FRotator(0, 0, 0); };

	//Input functions
	//void Move_XAxis(float AxisValue);
	//void Move_YAxis(float AxisValue);

	UPROPERTY()
	class UWidgetInteractionComponent* interaction;

	UPROPERTY()
	class UCameraComponent* camera;

private:

	void LeftMouseButtonPressed();

	void LeftMouseButtonReleased();

	void TraceFromPointer();

	void TraceFromMouseCursor();

	void CheckPointCloudHit(FHitResult hit_result);

	FVector current_velocity_;

	FRotator current_rotation_;


};
