// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "GameFramework/Actor.h"
#include "ModelPC.generated.h"

UCLASS()
class BACHELORPROTOTYPE_API AModelPC : public AActor
{
	GENERATED_BODY()
	
public:	
	// Sets default values for this actor's properties
	AModelPC();

	// Called every frame
	virtual void Tick(float DeltaTime) override;

	void SetPointCloudByName(FString desired_name);

	void SetPointCloudByIndex(int index);

	int FindPointCloudIndex(class UPointCloud* pc);

	void SwitchPointCloud();

	bool IsUserLooking();

	float DistanceFromUser();

	void LabelFaceUser();

	void Show();

	void SetupButtons();

	void LoadButtonsLabels();

	UPROPERTY(EditAnywhere)
	class UPointCloudComponent* pc_component;

	UPROPERTY()
	class ATextRenderActor* text_label;

	UPROPERTY()
	TArray<UPointCloud*> pointclouds;

	UPROPERTY()
	class AUser* user;

	UPROPERTY()
	TSubclassOf<class UUserWidget> menu_class;

	UPROPERTY()
	class UUserWidget* menu;

	UFUNCTION()
	void ButtonSwitch();

	UFUNCTION()
	void Button0();

	UFUNCTION()
	void Button1();

	UFUNCTION()
	void Button2();

protected:
	// Called when the game starts or when spawned
	virtual void BeginPlay() override;

private:

	void SpawnTextLabel();

	void LoadPointCloudsFromScene();

	int pc_index_ = 0;
	
};
