// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "PointCloudComponent.h"
#include "PointCloud.h"
#include "PointCloudScan.generated.h"

UCLASS()
class BACHELORPROTOTYPE_API UPointCloudScan : public UPointCloudComponent
{
	GENERATED_BODY()
	
public:

	//methods

	virtual void TickComponent(float DeltaTime, ELevelTick TickType, FActorComponentTickFunction* ThisTickFunction) override;

	void ResetPointCloudData();

	void LoadPointCloudData();

	void PrintAverageCoordsInSection(int32 from, int32 to);

	void PrintPointsCoords();

	void SetSpriteSize(float size);

	void SetColor(FColor color);

	void SetColorOfPoints(int32 from, int32 to, FColor color);

	void SetRenderMethod(EPointCloudRenderMethod method);

	float GetMaxExtent();

	float GetMinExtent();

	void Reimport();

	UFUNCTION(BluePrintCallable, Category = "ScanFunctions")
	int32 GetScanNumberOfPoints();

	UFUNCTION(BluePrintCallable, Category = "ScanFunctions")
	void DeletePoints(int32 from, int32 to);

	UFUNCTION(BluePrintCallable, Category = "ScanFunctions")
	void ColorPointNeighborhood(int32 point_number, int distance, FColor color);

	UFUNCTION(BluePrintCallable, Category = "ScanFunctions")
	int32 FindPointNumber(float X, float Y, float Z);

	UFUNCTION(BluePrintCallable, Category = "ScanFunctions")
	void ChangeScanSourcePath(FString FileName);

	UFUNCTION(BluePrintCallable, Category = "ScanFunctions")
	class UPointCloudOctreeCustom* GetOctree() { return octree; }

	UFUNCTION(BluePrintCallable, Category = "ScanFunctions")
	void ToggleOctreeVisibility();

	//properties

	UPROPERTY()
	TArray<FPointCloudPoint> edit_points;

	UPROPERTY()
	TArray<FPointCloudPoint> original_points;

	UPROPERTY()
	class UPointCloudOctreeCustom* octree;

protected:

	UPointCloudScan();

	virtual void BeginPlay() override;

	virtual void EndPlay(const EEndPlayReason::Type EndPlayReason) override;

};
