// Fill out your copyright notice in the Description page of Project Settings.

#include "SphereSpawner.h"
#include "Components/StaticMeshComponent.h"
#include "Engine/EngineTypes.h"
#include <iostream>
#include <sstream>
#include <fstream>
#include "EngineUtils.h"
#include "ConstructorHelpers.h"

using namespace std;

// Sets default values
ASphereSpawner::ASphereSpawner()
{
 	// Set this actor to call Tick() every frame.  You can turn this off to improve performance if you don't need it.
	PrimaryActorTick.bCanEverTick = true;

	static ConstructorHelpers::FObjectFinder<UStaticMesh> sphere_mesh_ob(TEXT("/Engine/BasicShapes/Sphere"));
	static ConstructorHelpers::FObjectFinder<UMaterialInterface> material_ob(TEXT("/Game/Materials/TestMaterial"));
	mesh = CreateDefaultSubobject<UStaticMeshComponent>(TEXT("Sphere"));
	mesh->SetStaticMesh(sphere_mesh_ob.Object);
	mesh->SetMaterial(0, material_ob.Object);
	RootComponent = mesh;
}

// Called when the game starts or when spawned
void ASphereSpawner::BeginPlay()
{
	Super::BeginPlay();
	mesh->ToggleVisibility();
	//LoadCoords(FString("S:/UNREAL PROJECTS/XYZ Files/sphere.xyz"));
	SpawnSpheres();
}

void ASphereSpawner::SpawnSpheres() {
	if (mesh && coords_) {
		for (int i = 0; i < coords_count_; i++) {
			UStaticMeshComponent* sphere = NewObject<UStaticMeshComponent>(this, UStaticMeshComponent::StaticClass());

			sphere->OnComponentCreated();
			sphere->RegisterComponent();
			sphere->AttachTo(RootComponent);
			sphere->SetRelativeScale3D(FVector(0.05f, 0.05f, 0.05f));
			sphere->SetMaterial(0, mesh->GetMaterial(0));
			sphere->SetStaticMesh(mesh->GetStaticMesh());
			sphere->SetRelativeLocation(coords_[i]);
			//sphere->SetMobility(EComponentMobility::Movable);
			//UE_LOG(LogTemp, Log, TEXT("Spawning Sphere %d"), i);
		}
	}
}

bool ASphereSpawner::LoadCoords(FString fileName) 
{
	//load and check the file
	ifstream input(TCHAR_TO_ANSI(*fileName));
	if (!input) { 
		UE_LOG(LogTemp, Log, TEXT("File not found!"));
		return false; 
	}
	//count number of lines//
	string line;
	coords_count_ = 0;
	while (getline(input, line)) { coords_count_++; }
	input.clear();
	input.seekg(0, ios::beg);
	//delete and allocate new coords//
	delete[] coords_;
	coords_ = new FVector[coords_count_];
	//read and save coords//
	int i = 0;
	while (getline(input, line)) { 
		istringstream stream(line);
		double x, y, z;
		if (stream >> x >> y >> z) {
			coords_[i] = FVector(x*100, y*100, z*100);
		}
		i++; 
	}
	//close and exit
	input.close();
	return true;
}

// Called every frame
void ASphereSpawner::Tick(float DeltaTime)
{
	Super::Tick(DeltaTime);
	AddActorLocalRotation(FRotator(10, 10, 10) * DeltaTime);
}

