// Fill out your copyright notice in the Description page of Project Settings.

#pragma once

#include "CoreMinimal.h"
#include "GameFramework/Actor.h"
#include "PointCloudScan.h"
#include "PointCloud.h"
#include "PointCloudEdit.generated.h"


UCLASS()
class BACHELORPROTOTYPE_API APointCloudEdit : public AActor
{
	GENERATED_BODY()
	
public:	
	// Sets default values for this actor's properties
	APointCloudEdit();

	// Called every frame
	virtual void Tick(float DeltaTime) override;

	void SetSpriteSize(float size);

	void SetVisibility(bool value);

	void ExperimentalColors();

	UFUNCTION(BluePrintCallable, Category = "PointCloudFunctions")
	int32 GetNumberOfPoints();
	
	UFUNCTION(BluePrintCallable, Category = "PointCloudFunctions")
	void Rotate(FRotator rotate) { AddActorLocalRotation(rotate); };

	UFUNCTION(BluePrintCallable, Category = "PointCloudFunctions")
	void ResetRotation() { SetActorRotation(FRotator(0, 0, 0)); };

	UFUNCTION(BluePrintCallable, Category = "PointCloudFunctions")
	void GenerateColors();

	UFUNCTION(BluePrintCallable, Category = "PointCloudFunctions")
	void ResetColors();

	UFUNCTION(BluePrintCallable, Category = "PointCloudFunctions")
	void ResetPointCloudData();

	UFUNCTION(BluePrintCallable, Category = "PointCloudFunctions")
	void CoolCompose();

	UFUNCTION(BluePrintCallable, Category = "PointCloudFunctions")
	void IterateSpriteSizes();

	UFUNCTION(BluePrintCallable, Category = "PointCloudFunctions")
	void ToggleVisibility(int scan_number);

	UFUNCTION(BluePrintCallable, Category = "PointCloudFunctions")
	void FindScanColorPointNeighborhood(float X, float Y, float Z, FColor color);

	UFUNCTION(BluePrintCallable, Category = "PointCloudFunctions")
	UPointCloudScan* GetScan(int scan_number) { return scans_[scan_number]; };

protected:
	// Called when the game starts or when spawned
	virtual void BeginPlay() override;

	virtual void EndPlay(const EEndPlayReason::Type EndPlayReason) override;

private:

	int current_quarter = 0;

	int counter = 0;

	FRotator rotator = FRotator(0.0f, 0.01f, 0.0f);

	float sprite_size = 0.3f;

	bool compose_flag = false;

	const int NUMBER_OF_SCANS = 3;

	///

	UPROPERTY()
	USceneComponent* root_;

	UPROPERTY()
	TArray<UPointCloudScan*> scans_;

	UPROPERTY(EditAnywhere)
	TArray<UPointCloud*> pointclouds_;

	UPROPERTY(EditAnywhere)
	UStaticMeshComponent* collider_;

};
