package root;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.sql.*;
import java.util.HashMap;
import java.util.Map;

import root.ui.MainMenu;

/**
 *
 * @author luk
 */
public class Main {
    public static Map<Integer, String> classNames;

    public static void main(String[] args) throws SQLException, IOException {
        String url = "jdbc:postgresql://db.ii.fmph.uniba.sk/playground";
        String username = "gajdosech2@uniba.sk";
        String password = "datakyseliny";
        try (Connection connection = DriverManager.getConnection(url, username, password)) {
            DbContext.setConnection(connection);
            loadClassNames();
            MainMenu mainMenu = new MainMenu();
            mainMenu.run();
        } catch (SQLException e) {
            e.printStackTrace();
        } finally {
            DbContext.getConnection().close();
            DbContext.clear();
        }
    }

    private static void loadClassNames() throws SQLException {
        classNames = new HashMap<>();
        Connection c = DbContext.getConnection();
        Statement s = c.createStatement();
        ResultSet r = s.executeQuery("SELECT id, name FROM classes");
        while (r.next()) {
            Integer key = r.getInt("id");
            String value = r.getString("name");
            classNames.put(key, value);
        }
    }

    public static void createScript() {
        runScript("/Users/luk/Google Drive/Škola/Aplikovaná Informatika/II.R - Letný/Databázy (2)/Projekt_aplikacia/src/root/sql/create_script.sql");
        runScript("/Users/luk/Google Drive/Škola/Aplikovaná Informatika/II.R - Letný/Databázy (2)/Projekt_aplikacia/src/root/sql/generate_script.sql");
    }

    private static void runScript(String filePath) {
        try {
            Connection c = DbContext.getConnection();
            Statement s = c.createStatement();
            BufferedReader in = new BufferedReader(new FileReader(filePath));
            String str;
            StringBuffer sb = new StringBuffer();
            while ((str = in.readLine()) != null) {
                sb.append(str + "\n ");
            }
            s.execute(sb.toString());
            in.close();
            s.close();
        } catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

}
