package root.rdg;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

/**
 *
 * @author luk
 */
public class ChangeModel extends Service {

    private int characterId;

    public int getCharacterId() { return characterId; }

    public void setCharacterId(int characterId) { this.characterId = characterId; }

    @Override
    public void insert() throws SQLException {
        insert("INSERT INTO services (kedy, price, user_id, service_type, character_id) VALUES (?,30,?,'change_model',?)");
    }

    @Override
    protected void insertFill(PreparedStatement s) throws SQLException {
        s.setDate(1, kedy);
        s.setInt(2, userId);
        s.setInt(3, characterId);
    }

    @Override
    protected void insertUpdateKeys(ResultSet r) throws SQLException {
        id = r.getInt(1);
    }

    @Override
    public void update() throws SQLException {
        update("UPDATE services SET kedy = ?, price = 30, user_id = ?, character_id = ? WHERE id = ?");
    }

    @Override
    protected void updateFill(PreparedStatement s) throws SQLException {
        s.setDate(1, kedy);
        s.setInt(2, userId);
        s.setInt(3, characterId);
        s.setInt(4, id);
    }

    @Override
    public void delete() throws SQLException {
        delete("DELETE FROM services WHERE id = ?");
    }

    @Override
    protected void deleteFill(PreparedStatement s) throws SQLException {
        s.setInt(1, id);
    }

}
