package root.rdg;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

/**
 *
 * @author luk
 */
public class ItemFinder extends BaseFinder<Item> {

    private static final ItemFinder INSTANCE = new ItemFinder();

    public static ItemFinder getInstance() { return INSTANCE; }

    private ItemFinder() { }

    public Item findById(int id) throws SQLException {
        return findByInt("SELECT * FROM items WHERE id = ?", id);
    }

    public List<Item> findAll() throws SQLException {
        return findAll("SELECT * FROM items");
    }

    @Override
    protected Item load(ResultSet r) throws SQLException {
        Item i = new Item();
        i.setId(r.getInt("id"));
        i.setName(r.getString("name"));
        i.setHpMod(r.getDouble("hp_mod"));
        i.setDefMod(r.getDouble("def_mod"));
        i.setStrMod(r.getDouble("str_mod"));
        return i;
    }
}
