package root.rdg;

import root.DbContext;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.List;

/**
 *
 * @author luk
 */
public class OccupancyStatisticFinder extends BaseFinder<OccupancyStatistic> {

    private static final OccupancyStatisticFinder INSTANCE = new OccupancyStatisticFinder();

    public static OccupancyStatisticFinder getInstance() {
        return INSTANCE;
    }

    private OccupancyStatisticFinder() { }

    public List<OccupancyStatistic> findAll() throws SQLException {
        return findAll("SELECT\n" +
                "   'PROS' as squad,\n" +
                "   pk.tyzden,\n" +
                "   count(*) as players,\n" +
                "   sum(pk.kills) as total_kills,\n" +
                "   bdh.den as best_day,\n" +
                "   bdh.hodina as best_hour\n" +
                "FROM player_kills() as pk JOIN best_day_hour_pros() as bdh ON bdh.tyzden = pk.tyzden\n" +
                "WHERE pk.p_id in (SELECT p_id from top_players WHERE tyzden = pk.tyzden)\n" +
                "GROUP BY pk.tyzden, bdh.den, bdh.hodina\n" +
                "UNION\n" +
                "SELECT\n" +
                "  'CASUALS' as squad,\n" +
                "  pk.tyzden,\n" +
                "  count(*) as players,\n" +
                "  sum(pk.kills) as total_kills,\n" +
                "  bdh.den as best_day,\n" +
                "  bdh.hodina as best_hour\n" +
                "FROM player_kills() as pk JOIN best_day_hour_casuals() as bdh ON bdh.tyzden = pk.tyzden\n" +
                "WHERE pk.p_id not in (SELECT p_id from top_players WHERE tyzden = pk.tyzden)\n" +
                "GROUP BY pk.tyzden, bdh.den, bdh.hodina\n" +
                "ORDER BY tyzden, squad;");
    }

    public List<OccupancyStatistic> findAllMin() throws SQLException {
        return findAll("SELECT 'PROS' as squad,\n" +
                "  pk.tyzden,\n" +
                "  count(*) as players,\n" +
                "  sum(pk.kills) as total_kills\n" +
                "FROM player_kills() as pk\n" +
                "WHERE pk.p_id in (SELECT p_id from top_players WHERE tyzden = pk.tyzden)\n" +
                "GROUP BY pk.tyzden, squad\n" +
                "UNION\n" +
                "SELECT 'CASUALS' as squad,\n" +
                "  pk.tyzden,\n" +
                "  count(*) as players,\n" +
                "  sum(pk.kills) as total_kills\n" +
                "FROM player_kills() as pk\n" +
                "WHERE pk.p_id not in (SELECT p_id from top_players WHERE tyzden = pk.tyzden)\n" +
                "GROUP BY pk.tyzden, squad\n" +
                "ORDER BY tyzden, squad;");
    }

    private int lastWeek() throws SQLException {
        Connection c = DbContext.getConnection();
        Statement s = c.createStatement();
        ResultSet r = s.executeQuery("SELECT date_part('week', kedy) as tyz FROM kills ORDER BY tyz DESC LIMIT 1;");
        if (r.next())
            return r.getInt(1);
        else
            return 0;
    }

    @Override
    protected OccupancyStatistic load(ResultSet r) throws SQLException {
        OccupancyStatistic o = new OccupancyStatistic();

        o.setSquad(r.getString("squad"));
        o.setWeek(r.getInt("tyzden"));
        o.setPlayers(r.getInt("players"));
        o.setTotalKills(r.getInt("total_kills"));
        try {
            o.setBestDay(r.getString("best_day"));
            o.setBestHour(r.getInt("best_hour"));
        } catch (SQLException e) {
            o.setBestDay("LITE");
            o.setBestHour(0);
        }

        return o;
    }

}
